/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.support;

import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.support.RefChainElement;
import com.oracle.joverflow.support.RefChainElementImpl;
import java.util.ArrayList;
import java.util.List;

public class ReferenceChain {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static List<RefChainElement> getChain(RefChainElement referer) {
        ArrayList<RefChainElement> reverseResult = new ArrayList<RefChainElement>();
        do {
            reverseResult.add(referer);
        } while ((referer = referer.getReferer()) != null);
        if (reverseResult.size() == 1) {
            return reverseResult;
        }
        ArrayList<RefChainElement> result = new ArrayList<RefChainElement>(reverseResult.size());
        int i = reverseResult.size() - 1;
        while (i >= 0) {
            result.add(reverseResult.get(i));
            --i;
        }
        return result;
    }

    public static RefChainElement getRootElement(RefChainElement referer) {
        RefChainElement parent = referer.getReferer();
        while (parent != null) {
            referer = parent;
            parent = referer.getReferer();
        }
        return referer;
    }

    public static String toStringInReverseOrder(RefChainElement referer, int maxChainDepth) {
        return ReferenceChain.toStringInReverseOrder(referer, maxChainDepth, EMPTY_STRING_ARRAY);
    }

    public static String toStringInReverseOrder(RefChainElement referer, int maxChainDepth, String[] stopperClassPrefixes) {
        StringBuilder sb = new StringBuilder(200);
        RefChainElement curElement = referer;
        int endIdx = 0;
        while (curElement != null) {
            JavaClass clazz = curElement.getJavaClass();
            if (clazz != null && ReferenceChain.startsWithOneOf(clazz.getName(), stopperClassPrefixes)) break;
            curElement = curElement.getReferer();
            ++endIdx;
        }
        endIdx = curElement == null ? maxChainDepth : ++endIdx;
        curElement = referer;
        int i = 0;
        while (curElement != null && i < endIdx) {
            if (curElement.getReferer() != null) {
                sb.append("<--");
            } else {
                sb.append("<<-");
            }
            sb.append(curElement.toString());
            curElement = curElement.getReferer();
            ++i;
        }
        if (curElement != null) {
            sb.append("<--...");
            RefChainElement parent = curElement.getReferer();
            while (parent != null) {
                curElement = parent;
                parent = curElement.getReferer();
            }
            sb.append("<<-");
            sb.append(((RefChainElementImpl.GCRoot)curElement).getRoot().getIdString());
        }
        return sb.toString();
    }

    public static String toStringInStraightOrder(RefChainElement referer) {
        int startIdx;
        StringBuilder sb = new StringBuilder(80);
        List<RefChainElement> chain = ReferenceChain.getChain(referer);
        if (chain.get(startIdx = 0) instanceof RefChainElementImpl.GCRoot) {
            sb.append(((RefChainElementImpl.GCRoot)chain.get(startIdx)).getRoot().getIdString());
            sb.append("->>");
            ++startIdx;
        }
        int i = startIdx;
        while (i < chain.size() - 1) {
            sb.append(chain.get(i).toString());
            sb.append("-->");
            ++i;
        }
        sb.append(chain.get(chain.size() - 1).toString());
        return sb.toString();
    }

    private static boolean startsWithOneOf(String str, String[] prefixes) {
        if (prefixes.length == 0) {
            return false;
        }
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (str.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

