/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.support;

import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.support.ClassAndSizeCombo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClassAndSizeComboList
implements Cloneable {
    private LinkedList<ClassAndSizeCombo> list = new LinkedList();
    private int totalSize;

    public List<ClassAndSizeCombo> getFinalList() {
        ArrayList<ClassAndSizeCombo> result = new ArrayList<ClassAndSizeCombo>(this.list.size());
        result.addAll(this.list);
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void addInstanceInfo(JavaClass clazz, int size, int nInstances) {
        this.totalSize += size;
        for (ClassAndSizeCombo entry : this.list) {
            if (entry.getClazz() != clazz) continue;
            entry.addInstances(nInstances, size);
            return;
        }
        this.list.add(new ClassAndSizeCombo(clazz, nInstances, size));
    }

    public void merge(ClassAndSizeComboList other) {
        LinkedList<ClassAndSizeCombo> otherList = other.list;
        for (ClassAndSizeCombo entry : otherList) {
            this.addInstanceInfo(entry.getClazz(), entry.getSizeOrOvhd(), entry.getNumInstances());
        }
    }

    public ClassAndSizeComboList clone() {
        ClassAndSizeComboList result = new ClassAndSizeComboList();
        for (ClassAndSizeCombo entry : this.list) {
            result.list.add(entry.clone());
        }
        result.totalSize = this.totalSize;
        return result;
    }
}

