/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.DumpCorruptedException;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.stats.DetailedStatsCalculator;
import com.oracle.joverflow.stats.OverallStatsCalculator;
import com.oracle.joverflow.support.HeapStats;
import com.oracle.joverflow.support.ProblemRecorder;

public class StandardStatsCalculator {
    private final Snapshot snapshot;
    private final ProblemRecorder problemRecorder;
    private final boolean useBreadthFirst;
    private OverallStatsCalculator osc;
    private DetailedStatsCalculator dsc;
    private volatile int stage;

    public StandardStatsCalculator(Snapshot snapshot, ProblemRecorder problemRecorder, boolean useBreadthFirst) {
        this.snapshot = snapshot;
        this.problemRecorder = problemRecorder;
        this.useBreadthFirst = useBreadthFirst;
    }

    public HeapStats calculate() throws DumpCorruptedException, HprofParsingCancelledException {
        this.snapshot.setCalculatingStats(true);
        try {
            this.osc = new OverallStatsCalculator(this.snapshot);
            this.stage = 1;
            HeapStats hs = this.osc.calculate();
            this.osc = null;
            this.problemRecorder.initialize(this.snapshot, hs);
            this.dsc = new DetailedStatsCalculator(this.snapshot, hs, this.problemRecorder, this.useBreadthFirst);
            this.stage = 2;
            this.dsc.calculate();
            HeapStats heapStats = hs;
            return heapStats;
        }
        catch (DumpCorruptedException.Runtime ex) {
            throw ex.getCause();
        }
        finally {
            this.snapshot.setCalculatingStats(false);
        }
    }

    public synchronized int getProgressPercentage() {
        switch (this.stage) {
            case 0: {
                return 0;
            }
            case 1: {
                OverallStatsCalculator localOsc = this.osc;
                if (localOsc == null) {
                    return 33;
                }
                return localOsc.getProgressPercentage() / 3;
            }
            case 2: {
                return 33 + this.dsc.getProgressPercentage() * 2 / 3;
            }
        }
        return 0;
    }

    public synchronized void cancelCalculation() {
        DetailedStatsCalculator localDsc;
        OverallStatsCalculator localOsc = this.osc;
        if (localOsc != null) {
            this.osc.cancelCalculation();
        }
        if ((localDsc = this.dsc) != null) {
            localDsc.cancelCalculation();
        }
    }
}

