/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaField;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.stats.DataFieldStats;
import com.oracle.joverflow.util.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ObjectHistogram {
    private final Snapshot snapshot;

    ObjectHistogram(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public List<Entry> getListSortedByInclusiveSize(int minInclusiveSize) {
        JavaClass[] classes = this.snapshot.getClasses();
        ArrayList<Entry> result = new ArrayList<Entry>(minInclusiveSize == 0 ? classes.length : classes.length / 100);
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            if (clazz.getTotalInclusiveInstanceSize() >= (long)minInclusiveSize) {
                result.add(new Entry(clazz));
            }
            ++n2;
        }
        Collections.sort(result, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                long diff = o2.getTotalInclusiveSize() - o1.getTotalInclusiveSize();
                if (diff > 0L) {
                    return 1;
                }
                if (diff < 0L) {
                    return -1;
                }
                return o1.getClazz().getName().compareTo(o2.getClazz().getName());
            }
        });
        return result;
    }

    public int[] calculateNumSmallInstClasses() {
        JavaClass[] classes;
        int numZeroInstObjects = 0;
        int numOneInstObjects = 0;
        JavaClass[] javaClassArray = classes = this.snapshot.getClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            int numInst = clazz.getNumInstances();
            switch (numInst) {
                case 0: {
                    ++numZeroInstObjects;
                    break;
                }
                case 1: {
                    ++numOneInstObjects;
                }
            }
            ++n2;
        }
        return new int[]{numZeroInstObjects, numOneInstObjects};
    }

    public List<ProblemFieldsEntry> getListSortedByNullFieldsOvhd(float percentile) {
        ArrayList<ProblemFieldsEntry> result = this.findClassesWithNullFields(percentile);
        this.checkForSuperclassesDefiningProblemFields(result);
        Collections.sort(result);
        return result;
    }

    public List<ProblemFieldsEntry> getListSortedByUnusedHiByteFieldsOvhd(float percentile) {
        ArrayList<ProblemFieldsEntry> result = this.findClassesWithUnusedHiByteFields(percentile);
        this.checkForSuperclassesDefiningProblemFields(result);
        Collections.sort(result);
        return result;
    }

    private ArrayList<ProblemFieldsEntry> findClassesWithNullFields(float percentile) {
        JavaClass[] classes = this.snapshot.getClasses();
        ArrayList<ProblemFieldsEntry> result = new ArrayList<ProblemFieldsEntry>(classes.length / 100);
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldStats stats;
            JavaClass clazz = javaClassArray[n2];
            if (!clazz.isString() && clazz.getNumInstances() != 0 && (stats = (DataFieldStats)clazz.getAttachment()) != null) {
                int numClazzInstances = clazz.getNumInstances();
                int maxNonNullFieldInstances = percentile == 1.0f ? 0 : (int)((float)numClazzInstances * (1.0f - percentile));
                int[] emptyFields = stats.getPercentileEmptyFields(maxNonNullFieldInstances);
                if (emptyFields != DataFieldStats.NO_REQUESTED_FIELDS) {
                    ProblemFieldsEntry.Status status = stats.getNumFields() == 0 ? ProblemFieldsEntry.Status.NO_FIELDS : (stats.getNumFields() == emptyFields.length ? ProblemFieldsEntry.Status.ALL_FIELDS_EMPTY : ProblemFieldsEntry.Status.SOME_FIELDS_EMPTY);
                    String[] emptyFieldNames = new String[emptyFields.length];
                    JavaClass[] emptyFieldDeclaringClasses = new JavaClass[emptyFields.length];
                    long[] perFieldOvhd = new long[emptyFields.length];
                    long allFieldsOvhd = 0L;
                    int i = 0;
                    while (i < emptyFields.length) {
                        int fieldIdx = emptyFields[i];
                        JavaField field = clazz.getFieldForInstance(fieldIdx);
                        emptyFieldNames[i] = field.getName();
                        emptyFieldDeclaringClasses[i] = clazz.getDeclaringClassForField(fieldIdx);
                        perFieldOvhd[i] = (long)field.getSizeInInstance() * (long)(numClazzInstances - stats.getNumInstancesWithFieldNotNull(fieldIdx));
                        allFieldsOvhd += perFieldOvhd[i];
                        ++i;
                    }
                    if ((double)percentile == 1.0 && status == ProblemFieldsEntry.Status.ALL_FIELDS_EMPTY || stats.getNumFields() == 0) {
                        allFieldsOvhd = (long)clazz.getInstanceSize() * (long)numClazzInstances;
                    }
                    ProblemFieldsEntry entry = new ProblemFieldsEntry(clazz, emptyFieldNames, emptyFieldDeclaringClasses, perFieldOvhd, allFieldsOvhd, status);
                    result.add(entry);
                }
            }
            ++n2;
        }
        return result;
    }

    private ArrayList<ProblemFieldsEntry> findClassesWithUnusedHiByteFields(float percentile) {
        JavaClass[] classes = this.snapshot.getClasses();
        ArrayList<ProblemFieldsEntry> result = new ArrayList<ProblemFieldsEntry>(classes.length / 100);
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            DataFieldStats stats;
            JavaClass clazz = javaClassArray[n2];
            if (!clazz.isString() && clazz.getNumInstances() != 0 && (stats = (DataFieldStats)clazz.getAttachment()) != null) {
                int numClazzInstances = clazz.getNumInstances();
                int minBadInstances = percentile == 1.0f ? numClazzInstances : (int)((float)numClazzInstances * percentile);
                DataFieldStats.UnderutilizedFields problemFields = stats.getUnusedHiBytesFields(minBadInstances);
                if (problemFields != null) {
                    int nProblemFields = problemFields.fieldIndices.length;
                    String[] problemFieldNames = new String[nProblemFields];
                    JavaClass[] emptyFieldDeclaringClasses = new JavaClass[nProblemFields];
                    long[] perFieldOvhd = new long[nProblemFields];
                    long allFieldsOvhd = 0L;
                    int i = 0;
                    while (i < nProblemFields) {
                        int fieldIdx = problemFields.fieldIndices[i];
                        JavaField field = clazz.getFieldForInstance(fieldIdx);
                        problemFieldNames[i] = field.getName();
                        emptyFieldDeclaringClasses[i] = clazz.getDeclaringClassForField(fieldIdx);
                        perFieldOvhd[i] = problemFields.unusedBytesOvhd[i];
                        allFieldsOvhd += perFieldOvhd[i];
                        ++i;
                    }
                    ProblemFieldsEntry entry = new ProblemFieldsEntry(clazz, problemFieldNames, emptyFieldDeclaringClasses, perFieldOvhd, allFieldsOvhd, ProblemFieldsEntry.Status.SOME_FIELDS_UNUSED_HI_BYTES);
                    result.add(entry);
                }
            }
            ++n2;
        }
        return result;
    }

    private void checkForSuperclassesDefiningProblemFields(ArrayList<ProblemFieldsEntry> entries) {
        HashMap<String, ProblemFieldsEntry> classToEntry = new HashMap<String, ProblemFieldsEntry>();
        for (ProblemFieldsEntry entry : entries) {
            classToEntry.put(entry.getClazz().getName(), entry);
        }
        HashMap<String, IntArrayList> classToFields = new HashMap<String, IntArrayList>();
        HashSet<String> superclasses = new HashSet<String>();
        for (ProblemFieldsEntry entry : entries) {
            String entryClassName = entry.getClazz().getName();
            JavaClass[] declaringClasses = entry.problemFieldDeclaringClasses;
            int i = 0;
            while (i < declaringClasses.length) {
                if (!entryClassName.equals(declaringClasses[i].getName())) {
                    ProblemFieldsEntry superclassEntry;
                    String fieldName = entry.problemFieldNames[i];
                    JavaClass superClazz = entry.problemFieldDeclaringClasses[i];
                    String superName = superClazz.getName();
                    if (superClazz.getNumInstances() <= 0 || (superclassEntry = (ProblemFieldsEntry)classToEntry.get(superName)) == null || superclassEntry.containsField(fieldName, superClazz) != -1) {
                        ArrayList<JavaClass> subclazzes = superClazz.getSubclasses();
                        int numSubclazzesWithNullField = 0;
                        for (JavaClass subclazz : subclazzes) {
                            String subclazzName = subclazz.getName();
                            ProblemFieldsEntry entry1 = (ProblemFieldsEntry)classToEntry.get(subclazzName);
                            if (entry1 == null || entry1.containsField(fieldName, superClazz) == -1) continue;
                            ++numSubclazzesWithNullField;
                            break;
                        }
                        if (numSubclazzesWithNullField == subclazzes.size()) {
                            IntArrayList fields = (IntArrayList)classToFields.get(entryClassName);
                            if (fields == null) {
                                fields = new IntArrayList(8);
                                classToFields.put(entryClassName, fields);
                            }
                            fields.add(i);
                            superclasses.add(superName);
                        }
                    }
                }
                ++i;
            }
        }
        if (classToFields.isEmpty()) {
            return;
        }
    }

    public static class Entry {
        private final JavaClass clazz;

        private Entry(JavaClass clazz) {
            this.clazz = clazz;
        }

        public JavaClass getClazz() {
            return this.clazz;
        }

        public int getNumInstances() {
            return this.clazz.getNumInstances();
        }

        public long getTotalInclusiveSize() {
            return this.clazz.getTotalInclusiveInstanceSize();
        }

        public long getTotalShallowSize() {
            return this.clazz.getTotalShallowInstanceSize();
        }
    }

    public static class ProblemFieldsEntry
    implements Comparable<ProblemFieldsEntry> {
        private final JavaClass clazz;
        private final int numInstances;
        private final String[] problemFieldNames;
        private final JavaClass[] problemFieldDeclaringClasses;
        private final long[] perFieldOvhd;
        private final long allProblemFieldsOvhd;
        private final Status status;

        private ProblemFieldsEntry(JavaClass clazz, String[] problemFieldNames, JavaClass[] problemFieldDeclaringClasses, long[] perFieldOvhd, long totalOverhead, Status status) {
            this.clazz = clazz;
            this.numInstances = clazz.getNumInstances();
            this.problemFieldNames = problemFieldNames;
            this.problemFieldDeclaringClasses = problemFieldDeclaringClasses;
            this.perFieldOvhd = perFieldOvhd;
            this.allProblemFieldsOvhd = totalOverhead;
            this.status = status;
        }

        public JavaClass getClazz() {
            return this.clazz;
        }

        public int getNumInstances() {
            return this.numInstances;
        }

        public long getAllProblemFieldsOvhd() {
            return this.allProblemFieldsOvhd;
        }

        public String[] getProblemFieldNames() {
            return this.problemFieldNames;
        }

        public JavaClass[] getProblemFieldDeclaringClasses() {
            return this.problemFieldDeclaringClasses;
        }

        public long[] getPerFieldOvhd() {
            return this.perFieldOvhd;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getFieldsAsString() {
            if (this.status == Status.ALL_FIELDS_EMPTY) {
                return "all";
            }
            if (this.status == Status.NO_FIELDS) {
                return "fieldless class";
            }
            StringBuilder result = new StringBuilder(this.problemFieldNames.length * 16);
            JavaClass declaringClass = null;
            JavaClass prevDeclaringClass = null;
            int i = 0;
            while (i < this.problemFieldNames.length) {
                declaringClass = this.problemFieldDeclaringClasses[i];
                if (prevDeclaringClass == null) {
                    prevDeclaringClass = declaringClass;
                }
                if (prevDeclaringClass != this.clazz && prevDeclaringClass != declaringClass) {
                    result.append(" (defined in ").append(prevDeclaringClass.getHumanFriendlyName()).append(")");
                }
                if (i > 0) {
                    if (declaringClass == prevDeclaringClass) {
                        result.append(", ");
                    } else {
                        result.append("; ");
                    }
                }
                prevDeclaringClass = declaringClass;
                result.append(this.problemFieldNames[i]);
                ++i;
            }
            if (declaringClass != this.clazz && declaringClass != null) {
                result.append(" (defined in ").append(declaringClass.getHumanFriendlyName()).append(")");
            }
            return result.toString();
        }

        public int containsField(String fieldName, JavaClass declaringClazz) {
            int j = 0;
            while (j < this.problemFieldNames.length) {
                if (this.problemFieldNames[j].equals(fieldName) && this.problemFieldDeclaringClasses[j] == declaringClazz) {
                    return j;
                }
                ++j;
            }
            return -1;
        }

        @Override
        public int compareTo(ProblemFieldsEntry other) {
            long diff = other.allProblemFieldsOvhd - this.allProblemFieldsOvhd;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }

        public static enum Status {
            SOME_FIELDS_EMPTY,
            ALL_FIELDS_EMPTY,
            NO_FIELDS,
            SOME_FIELDS_UNUSED_HI_BYTES;

        }
    }
}

