/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.batch.BatchProblemRecorder;
import com.oracle.joverflow.batch.DetailedStats;
import com.oracle.joverflow.batch.ReferencedObjCluster;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.stats.DetailedDupStringStatsCalculator;
import com.oracle.joverflow.support.DupStringStats;
import com.oracle.joverflow.support.ReferenceChain;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class LongLivedStringClustersCalculator {
    private final int numDumps;
    private final List<ReferencedObjCluster.DupStrings>[] dupStringsToFields;
    private volatile DetailedDupStringStatsCalculator ssc;
    private int curDumpNum;

    public LongLivedStringClustersCalculator(int numDumps) {
        this.numDumps = numDumps;
        this.dupStringsToFields = new ArrayList[numDumps];
    }

    public DupStringStats update(Snapshot snapshot) throws HprofParsingCancelledException {
        long totalObjSize = snapshot.getRoughTotalObjectSize();
        int minOverhead = (int)(totalObjSize / 1000L);
        BatchProblemRecorder recorder = new BatchProblemRecorder();
        this.ssc = new DetailedDupStringStatsCalculator(snapshot, recorder);
        DupStringStats dss = this.ssc.calculate();
        DetailedStats ds = recorder.getDetailedStats(minOverhead);
        this.dupStringsToFields[this.curDumpNum] = ds.dupStringClusters.get(1);
        ++this.curDumpNum;
        this.ssc = null;
        return dss;
    }

    public void calculate() {
        int minNumRepeats = this.numDumps / 2 + 1;
        LinkedHashSet<String> longLivedFields = new LinkedHashSet<String>();
        int i = 0;
        while (i < this.numDumps - minNumRepeats + 1) {
            List<ReferencedObjCluster.DupStrings> clusters1 = this.dupStringsToFields[i];
            for (ReferencedObjCluster referencedObjCluster : clusters1) {
                String classAndField1 = ReferenceChain.toStringInStraightOrder(referencedObjCluster.getReferer());
                int j = i + 1;
                while (j < this.numDumps) {
                    List<ReferencedObjCluster.DupStrings> clusters2 = this.dupStringsToFields[j];
                    for (ReferencedObjCluster referencedObjCluster2 : clusters2) {
                        if (!referencedObjCluster2.getReferer().toString().equals(classAndField1)) continue;
                        longLivedFields.add(classAndField1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("\nLONG-LIVED FIELDS:");
        for (String longLivedField : longLivedFields) {
            System.out.println(longLivedField);
        }
    }

    public int getProgressPercentage() {
        DetailedDupStringStatsCalculator sscCopy = this.ssc;
        if (sscCopy != null) {
            return sscCopy.getProgressPercentage();
        }
        return 100;
    }
}

