/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.util.IntToObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LengthHistogram {
    private final ArrayList<Entry> values;

    private LengthHistogram(ArrayList<Entry> values) {
        this.values = values;
    }

    public List<Entry> getPrunedAndSortedEntries(int sizeThreshold) {
        ArrayList<Entry> result = new ArrayList<Entry>(this.values.size() / 2);
        Entry entryForOthers = new Entry(-1);
        for (Entry entry : this.values) {
            if (entry.getSize() >= (long)sizeThreshold) {
                result.add(entry);
                continue;
            }
            entryForOthers.addEntry(entry);
        }
        result.add(entryForOthers);
        Collections.sort(result);
        return result;
    }

    /* synthetic */ LengthHistogram(ArrayList arrayList, LengthHistogram lengthHistogram) {
        this(arrayList);
    }

    public static class Builder {
        private final IntToObjectMap<Entry> lenToEntry;

        public Builder(int capacity) {
            this.lenToEntry = new IntToObjectMap(capacity, false);
        }

        public void addInstance(int length, int size) {
            Entry entry = this.lenToEntry.get(length);
            if (entry == null) {
                entry = new Entry(length);
                this.lenToEntry.put(length, entry);
            }
            entry.addInstance(size);
        }

        public LengthHistogram build() {
            ArrayList result = new ArrayList(this.lenToEntry.size());
            result.addAll(this.lenToEntry.values());
            return new LengthHistogram(result, null);
        }

        public int size() {
            return this.lenToEntry.size();
        }
    }

    public static class Entry
    implements Comparable<Entry> {
        public static final int SPECIAL_VALUE = -1;
        private final int length;
        private int count;
        private long size;

        private Entry(int length) {
            this.length = length;
        }

        private void addInstance(int instSize) {
            ++this.count;
            this.size += (long)instSize;
        }

        private void addEntry(Entry other) {
            this.count += other.count;
            this.size += other.size;
        }

        public int getLength() {
            return this.length;
        }

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.length == -1) {
                return 1;
            }
            if (other.length == -1) {
                return -1;
            }
            return this.length - other.length;
        }
    }
}

