/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.HeapStringReader;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.stats.InterimRefChain;
import com.oracle.joverflow.support.DupStringStats;
import com.oracle.joverflow.util.ValueWitIntIdMap;
import java.util.List;

public class DupStringHandler {
    private final HeapStringReader stringReader;
    private final ValueWitIntIdMap<DupStringStats.Entry> dupStrings;
    private final InterimRefChain refChain;
    private final int stringInstShallowSize;
    private JavaValueArray backingCharArray;

    DupStringHandler(HeapStringReader stringReader, List<DupStringStats.Entry> dupStringList, InterimRefChain refChain, int stringInstShallowSize) {
        this.stringReader = stringReader;
        this.dupStrings = new ValueWitIntIdMap(dupStringList.size());
        for (DupStringStats.Entry entry : dupStringList) {
            this.dupStrings.put(entry);
        }
        this.refChain = refChain;
        this.stringInstShallowSize = stringInstShallowSize;
    }

    boolean handleString(JavaObject strObj) {
        int internalId = strObj.getInternalId();
        DupStringStats.Entry se = this.dupStrings.get(internalId);
        if (se == null) {
            return false;
        }
        this.backingCharArray = this.stringReader.getCharArrayForString(strObj);
        if (this.backingCharArray == null) {
            return false;
        }
        int implInclusiveSize = this.stringInstShallowSize;
        int ovhd = se.getOvhdForNextStringCopy();
        boolean hasDupBackingCharArray = false;
        if (!this.backingCharArray.isVisited()) {
            implInclusiveSize += this.backingCharArray.getSize();
            hasDupBackingCharArray = true;
        }
        this.refChain.recordCurrentRefChainForDupString(strObj, se.string, implInclusiveSize, ovhd, hasDupBackingCharArray);
        return true;
    }

    JavaValueArray getLastReadBackingArray() {
        return this.backingCharArray;
    }
}

