/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.stats.InterimRefChain;
import com.oracle.joverflow.support.DupArrayStats;
import com.oracle.joverflow.util.ValueWitIntIdMap;
import java.util.List;

public class DupArrayHandler {
    private final ValueWitIntIdMap<DupArrayStats.Entry> dupArrays;
    private final InterimRefChain refChain;

    DupArrayHandler(List<DupArrayStats.Entry> dupArrayList, InterimRefChain refChain) {
        this.dupArrays = new ValueWitIntIdMap(dupArrayList.size());
        for (DupArrayStats.Entry entry : dupArrayList) {
            this.dupArrays.put(entry);
        }
        this.refChain = refChain;
    }

    boolean handleArray(JavaValueArray array) {
        boolean isDuplicate;
        int internalId = array.getInternalId();
        DupArrayStats.Entry ae = this.dupArrays.get(internalId);
        boolean bl = isDuplicate = ae != null;
        if (isDuplicate) {
            int ovhd = ae.getOvhdForNextArrayCopy();
            this.refChain.recordCurrentRefChainForDupArray(array, ovhd);
        } else {
            this.refChain.recordCurrentRefChainForNonDupArray(array);
        }
        return isDuplicate;
    }
}

