/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.descriptors.CollectionDescriptors;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.HeapStringReader;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaLazyReadObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.stats.DepthFirstHeapScaner;
import com.oracle.joverflow.stats.DupStringHandler;
import com.oracle.joverflow.stats.InterimRefChain;
import com.oracle.joverflow.stats.ProblemChecker;
import com.oracle.joverflow.stats.StringStatsCollector;
import com.oracle.joverflow.support.DupStringStats;
import com.oracle.joverflow.support.ProblemRecorder;
import java.util.Collection;

class DetailedDupStringStatsCalculator
implements ProblemChecker {
    private final Snapshot snapshot;
    private final InterimRefChain refChain;
    private final DepthFirstHeapScaner scaner;
    private final HeapStringReader stringReader;
    private DupStringHandler dupStringHandler;

    public DetailedDupStringStatsCalculator(Snapshot snapshot, ProblemRecorder recorder) {
        this.snapshot = snapshot;
        CollectionDescriptors colDescriptors = new CollectionDescriptors(snapshot);
        this.scaner = new DepthFirstHeapScaner(snapshot, this, recorder, colDescriptors);
        this.refChain = this.scaner.getRefChain();
        this.stringReader = snapshot.getStringReader();
    }

    public DupStringStats calculate() throws HprofParsingCancelledException {
        DupStringStats dss = this.findDupStrings();
        this.findRefsToDupStrings(dss);
        return dss;
    }

    private DupStringStats findDupStrings() {
        Collection<JavaLazyReadObject> allObjects = this.snapshot.getObjects();
        StringStatsCollector stringDupMap = new StringStatsCollector(this.snapshot);
        for (JavaLazyReadObject obj : allObjects) {
            JavaClass clazz = obj.getClazz();
            if (!clazz.isString()) continue;
            stringDupMap.add((JavaObject)obj);
        }
        return stringDupMap.getDuplicationStats();
    }

    private void findRefsToDupStrings(DupStringStats dss) throws HprofParsingCancelledException {
        this.dupStringHandler = new DupStringHandler(this.stringReader, dss.dupStrings, this.refChain, dss.stringInstShallowSize);
        this.scaner.analyzeViaRoots();
    }

    @Override
    public CollectionInstanceDescriptor handleInstance(JavaObject obj, JavaThing[] fields) {
        return null;
    }

    @Override
    public void handleObjectArray(JavaObjectArray array, JavaHeapObject[] elements) {
    }

    @Override
    public void handleValueArray(JavaValueArray array) {
    }

    @Override
    public void handleString(JavaObject strObj) {
        boolean isDuplicated = this.dupStringHandler.handleString(strObj);
        JavaValueArray backingCharArray = this.dupStringHandler.getLastReadBackingArray();
        if (backingCharArray != null) {
            backingCharArray.setVisited();
        }
        if (!isDuplicated) {
            this.refChain.recordCurrentRefChainForNonDupString(strObj, strObj.getSize() + backingCharArray.getSize());
        }
    }

    public int getProgressPercentage() {
        return this.scaner.getProgressPercentage();
    }
}

