/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.descriptors.CollectionDescriptors;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaLazyReadObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.JavaValueArray;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.stats.HeapScaner;
import com.oracle.joverflow.stats.InterimRefChainStack;
import com.oracle.joverflow.stats.ProblemChecker;
import com.oracle.joverflow.stats.TwoHandIndexContainer;
import com.oracle.joverflow.support.ProblemRecorder;
import com.oracle.joverflow.util.FastStack;

class DepthFirstHeapScaner
extends HeapScaner {
    private final ProblemChecker objHandler;
    private final FastStack<JavaThing[]> fieldsOrArrayElsStack;
    private final InterimRefChainStack refChain = (InterimRefChainStack)this.getRefChain();
    private boolean optimizeForLocality = false;

    DepthFirstHeapScaner(Snapshot snapshot, ProblemChecker objHandler, ProblemRecorder problemRecorder, CollectionDescriptors colDescriptors) {
        super(snapshot, new InterimRefChainStack(problemRecorder, colDescriptors));
        this.objHandler = objHandler;
        this.fieldsOrArrayElsStack = new FastStack(256);
    }

    @Override
    protected void scanObjectsFromRootObj(JavaHeapObject obj) {
        while (obj != null) {
            if (obj.setVisitedIfNot()) {
                ++this.currentProcessedObjNo;
                if (this.cancelled) {
                    throw new HprofParsingCancelledException.Runtime();
                }
                JavaClass clazz = obj.getClazz();
                this.refChain.push(obj);
                if (clazz.isString()) {
                    this.objHandler.handleString((JavaObject)obj);
                    this.refChain.pop();
                } else if (obj instanceof JavaObject) {
                    JavaObject javaObj = (JavaObject)obj;
                    JavaThing[] fields = javaObj.getFields();
                    this.objHandler.handleInstance(javaObj, fields);
                    int[] bannedFieldIndices = clazz.getBannedFieldIndices();
                    if (bannedFieldIndices != null) {
                        int[] nArray = bannedFieldIndices;
                        int n = bannedFieldIndices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int bannedFieldIdx = nArray[n2];
                            fields[bannedFieldIdx] = null;
                            ++n2;
                        }
                    }
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(fields);
                } else if (obj instanceof JavaClass) {
                    JavaThing[] staticFields = ((JavaClass)obj).getStaticValues();
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(staticFields);
                } else if (obj instanceof JavaObjectArray) {
                    JavaObjectArray objArray = (JavaObjectArray)obj;
                    JavaHeapObject[] elements = objArray.getElements();
                    this.objHandler.handleObjectArray(objArray, elements);
                    this.refChain.pushIndexContainer(new TwoHandIndexContainer());
                    this.fieldsOrArrayElsStack.push(elements);
                } else {
                    this.objHandler.handleValueArray((JavaValueArray)obj);
                    this.refChain.pop();
                }
            }
            obj = this.getNextObjToScan(obj);
        }
    }

    private JavaHeapObject getNextObjToScan(JavaHeapObject oldObj) {
        long oldObjOfsInFile = -1L;
        JavaHeapObject obj = null;
        while (!this.fieldsOrArrayElsStack.isEmpty()) {
            JavaThing[] fieldsOrElements = this.fieldsOrArrayElsStack.peek();
            TwoHandIndexContainer curIdxContainer = (TwoHandIndexContainer)this.refChain.getCurrentIndexContainer();
            int nextIdx = curIdxContainer.incrementAndGetBase();
            while (nextIdx < fieldsOrElements.length) {
                JavaThing objThing = fieldsOrElements[nextIdx];
                if (objThing != null && objThing instanceof JavaHeapObject) {
                    obj = (JavaHeapObject)objThing;
                    if (!obj.isVisited()) {
                        if (this.optimizeForLocality && obj instanceof JavaLazyReadObject) {
                            long l = oldObjOfsInFile = oldObj instanceof JavaLazyReadObject ? ((JavaLazyReadObject)oldObj).getObjOfsInFile() : -1L;
                            if (oldObjOfsInFile != -1L) {
                                curIdxContainer.setBase(nextIdx - 1);
                                break;
                            }
                        }
                        curIdxContainer.setBase(nextIdx);
                        curIdxContainer.set(nextIdx);
                        return obj;
                    }
                    obj = null;
                }
                ++nextIdx;
            }
            if (obj == null) {
                this.fieldsOrArrayElsStack.pop();
                this.refChain.pop2();
                continue;
            }
            long curObjOfsInFile = ((JavaLazyReadObject)obj).getObjOfsInFile();
            long minDistance = Math.abs(curObjOfsInFile - oldObjOfsInFile);
            int bestIdx = nextIdx++;
            int nCheckedFields = 0;
            while (nextIdx < fieldsOrElements.length && nCheckedFields < 8) {
                JavaThing objThing = fieldsOrElements[nextIdx];
                if (objThing != null && objThing instanceof JavaHeapObject && !(obj = (JavaHeapObject)objThing).isVisited()) {
                    if (!(obj instanceof JavaLazyReadObject)) {
                        curIdxContainer.set(nextIdx);
                        return obj;
                    }
                    ++nCheckedFields;
                    curObjOfsInFile = ((JavaLazyReadObject)obj).getObjOfsInFile();
                    long distance = Math.abs(curObjOfsInFile - oldObjOfsInFile);
                    if (distance < minDistance) {
                        bestIdx = nextIdx;
                        minDistance = distance;
                    }
                }
                ++nextIdx;
            }
            curIdxContainer.set(bestIdx);
            return (JavaHeapObject)fieldsOrElements[bestIdx];
        }
        return obj;
    }
}

