/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.JavaChar;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaField;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaInt;
import com.oracle.joverflow.heap.model.JavaLong;
import com.oracle.joverflow.heap.model.JavaShort;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.JavaValue;
import com.oracle.joverflow.util.IntArrayList;
import com.oracle.joverflow.util.LongArrayList;

public class DataFieldStats {
    public static final int[] NO_REQUESTED_FIELDS = new int[0];
    public static final int[] CLASS_HAS_NO_FIELDS = new int[0];
    private static final DataFieldStats EMPTY_STATS = new DataFieldStats(new JavaField[0]);
    private final JavaField[] allFields;
    private final int[] numInstancesWhereThisFieldIsNotNull;
    private final int[] numInstancesWhereThisFieldUnderutilizesHiBytes;
    private final byte[] minUnusedBytesForThisField;
    private int numInstancesWithAllNullFields;

    static DataFieldStats newInstance(JavaClass clazz) {
        if (clazz.isArray()) {
            return EMPTY_STATS;
        }
        JavaField[] allInstanceFields = clazz.getFieldsForInstance();
        return new DataFieldStats(allInstanceFields);
    }

    private DataFieldStats(JavaField[] allFields) {
        this.allFields = allFields;
        this.numInstancesWhereThisFieldIsNotNull = new int[allFields.length];
        this.numInstancesWhereThisFieldUnderutilizesHiBytes = new int[allFields.length];
        this.minUnusedBytesForThisField = new byte[allFields.length];
        int i = 0;
        while (i < this.minUnusedBytesForThisField.length) {
            this.minUnusedBytesForThisField[i] = 127;
            ++i;
        }
    }

    void handleFields(JavaThing[] fields) {
        boolean someNonNullFieldFound = false;
        int fieldIdx = 0;
        while (fieldIdx < fields.length) {
            JavaThing field = fields[fieldIdx];
            if (field != null) {
                if (field instanceof JavaHeapObject) {
                    int n = fieldIdx;
                    this.numInstancesWhereThisFieldIsNotNull[n] = this.numInstancesWhereThisFieldIsNotNull[n] + 1;
                    someNonNullFieldFound = true;
                } else {
                    JavaValue value = (JavaValue)field;
                    if (value.isZero()) {
                        int valueSize = value.getSize();
                        if (!value.isFloatingPointNumber() && valueSize > 1) {
                            int n = fieldIdx;
                            this.numInstancesWhereThisFieldUnderutilizesHiBytes[n] = this.numInstancesWhereThisFieldUnderutilizesHiBytes[n] + 1;
                            byte numUnusedBytes = (byte)valueSize;
                            if (numUnusedBytes < this.minUnusedBytesForThisField[fieldIdx]) {
                                this.minUnusedBytesForThisField[fieldIdx] = numUnusedBytes;
                            }
                        }
                    } else {
                        byte numUnusedBytes;
                        int n = fieldIdx;
                        this.numInstancesWhereThisFieldIsNotNull[n] = this.numInstancesWhereThisFieldIsNotNull[n] + 1;
                        someNonNullFieldFound = true;
                        if (!value.isFloatingPointNumber() && value.getSize() > 1 && (numUnusedBytes = this.getNumUnusedBytes(value)) > 0) {
                            int n2 = fieldIdx;
                            this.numInstancesWhereThisFieldUnderutilizesHiBytes[n2] = this.numInstancesWhereThisFieldUnderutilizesHiBytes[n2] + 1;
                            if (numUnusedBytes < this.minUnusedBytesForThisField[fieldIdx]) {
                                this.minUnusedBytesForThisField[fieldIdx] = numUnusedBytes;
                            }
                        }
                    }
                }
            }
            ++fieldIdx;
        }
        if (!someNonNullFieldFound) {
            ++this.numInstancesWithAllNullFields;
        }
    }

    public int[] getPercentileEmptyFields(int maxNonNullFieldInstances) {
        if (this.allFields.length == 0) {
            return CLASS_HAS_NO_FIELDS;
        }
        IntArrayList fieldIdxs = new IntArrayList(this.allFields.length);
        int i = 0;
        while (i < this.numInstancesWhereThisFieldIsNotNull.length) {
            int nNonNulls = this.numInstancesWhereThisFieldIsNotNull[i];
            if (nNonNulls >= 0 && nNonNulls <= maxNonNullFieldInstances) {
                fieldIdxs.add(i);
            }
            ++i;
        }
        if (fieldIdxs.size() == 0) {
            return NO_REQUESTED_FIELDS;
        }
        return fieldIdxs.toArray();
    }

    public int getNumInstancesWithFieldNotNull(int fieldIdx) {
        return this.numInstancesWhereThisFieldIsNotNull[fieldIdx];
    }

    public int getNumInstancesWithAllNullFields() {
        return this.numInstancesWithAllNullFields;
    }

    public UnderutilizedFields getUnusedHiBytesFields(int minBadInstances) {
        if (this.allFields.length == 0) {
            return null;
        }
        IntArrayList fieldIdxs = new IntArrayList(this.allFields.length);
        LongArrayList fieldOvhd = new LongArrayList(this.allFields.length);
        int i = 0;
        while (i < this.numInstancesWhereThisFieldUnderutilizesHiBytes.length) {
            byte minUnusedBytes;
            int nBadInstances = this.numInstancesWhereThisFieldUnderutilizesHiBytes[i];
            if (nBadInstances >= minBadInstances && (minUnusedBytes = this.minUnusedBytesForThisField[i]) != this.allFields[i].getSizeInInstance()) {
                fieldIdxs.add(i);
                fieldOvhd.add((long)minUnusedBytes * (long)nBadInstances);
            }
            ++i;
        }
        if (fieldIdxs.size() == 0) {
            return null;
        }
        return new UnderutilizedFields(fieldIdxs.toArray(), fieldOvhd.toArray());
    }

    public int getNumFields() {
        return this.allFields.length;
    }

    private byte getNumUnusedBytes(JavaValue value) {
        if (value instanceof JavaInt) {
            JavaInt intValue = (JavaInt)value;
            int val = intValue.getValue();
            if (val >= -128 && val <= 127) {
                return 3;
            }
            if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                return 2;
            }
            return 0;
        }
        if (value instanceof JavaChar) {
            JavaChar charValue = (JavaChar)value;
            char val = charValue.getValue();
            if (val <= '\u00ff') {
                return 1;
            }
            return 0;
        }
        if (value instanceof JavaShort) {
            JavaShort shortValue = (JavaShort)value;
            short val = shortValue.getValue();
            if (val >= -128 && val <= 127) {
                return 1;
            }
            return 0;
        }
        if (value instanceof JavaLong) {
            JavaLong longValue = (JavaLong)value;
            long val = longValue.getValue();
            if (val >= -128L && val <= 127L) {
                return 7;
            }
            if (val >= -32768L && val <= 32767L) {
                return 6;
            }
            if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public static class UnderutilizedFields {
        public final int[] fieldIndices;
        public final long[] unusedBytesOvhd;

        private UnderutilizedFields(int[] fieldIndices, long[] unusedBytesOvhd) {
            this.fieldIndices = fieldIndices;
            this.unusedBytesOvhd = unusedBytesOvhd;
        }
    }
}

