/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.stats;

import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.util.ObjectToIntMap;

public class ClassloaderStats {
    private final ObjectToIntMap<JavaObject> clInstToNumLoadedClasses = new ObjectToIntMap(10);
    private final ObjectToIntMap<JavaClass> clClazzToNumLoadedClasses = new ObjectToIntMap(10);

    ClassloaderStats(Snapshot snapshot) {
        JavaClass clazz;
        JavaClass[] classes;
        JavaClass[] javaClassArray = classes = snapshot.getClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            clazz = javaClassArray[n2];
            if (clazz.isOrSubclassOf("java.lang.ClassLoader")) {
                this.clClazzToNumLoadedClasses.put(clazz, 0);
            }
            ++n2;
        }
        javaClassArray = classes;
        n = classes.length;
        n2 = 0;
        while (n2 < n) {
            clazz = javaClassArray[n2];
            JavaThing loaderThing = clazz.getLoader();
            if (loaderThing instanceof JavaObject) {
                JavaObject loader = (JavaObject)loaderThing;
                this.clInstToNumLoadedClasses.putOneOrIncrement(loader);
                JavaClass loaderClazz = loader.getClazz();
                this.clClazzToNumLoadedClasses.putOneOrIncrement(loaderClazz);
            }
            ++n2;
        }
    }

    public ObjectToIntMap<JavaObject> getCLInstToNumLoadedClasses() {
        return this.clInstToNumLoadedClasses;
    }

    public ObjectToIntMap<JavaClass> getClClazzToNumLoadedClasses() {
        return this.clClazzToNumLoadedClasses;
    }
}

