/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.parser;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PositionInputStream
extends FilterInputStream {
    private long position = 0L;

    public PositionInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.position;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res != -1) {
            this.position += (long)res;
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = super.skip(n);
        this.position += res;
        return res;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("mark");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset");
    }

    public long position() {
        return this.position;
    }
}

