/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.parser;

import com.oracle.joverflow.heap.parser.ReadBuffer;
import java.io.IOException;

public class ByteArrayReadBuffer
extends ReadBuffer {
    private byte[] ar;

    ByteArrayReadBuffer(byte[] array) {
        this.ar = array;
    }

    @Override
    public void get(long longPos, byte[] buf) {
        System.arraycopy(this.ar, (int)longPos, buf, 0, buf.length);
    }

    @Override
    public void get(long longPos, byte[] buf, int num) {
        System.arraycopy(this.ar, (int)longPos, buf, 0, num);
    }

    @Override
    public int getInt(long longPos) {
        int pos = (int)longPos;
        return this.getInt(pos);
    }

    private int getInt(int pos) {
        return (this.ar[pos] & 0xFF) << 24 | (this.ar[pos + 1] & 0xFF) << 16 | (this.ar[pos + 2] & 0xFF) << 8 | this.ar[pos + 3] & 0xFF;
    }

    @Override
    public long getLong(long longPos) throws IOException {
        int pos = (int)longPos;
        return (long)this.getInt(pos) << 32 | (long)this.getInt(pos + 4) & 0xFFFFFFFFL;
    }

    @Override
    public void close() {
    }
}

