/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.model.StackFrame;

public class StackTrace {
    private StackFrame[] frames;

    public StackTrace(StackFrame[] frames) {
        this.frames = frames;
    }

    public StackTrace traceForDepth(int depth) {
        if (depth >= this.frames.length) {
            return this;
        }
        StackFrame[] f = new StackFrame[depth];
        System.arraycopy(this.frames, 0, f, 0, depth);
        return new StackTrace(f);
    }

    public void resolve(Snapshot snapshot) {
        int i = 0;
        while (i < this.frames.length) {
            this.frames[i].resolve(snapshot);
            ++i;
        }
    }

    public StackFrame[] getFrames() {
        return this.frames;
    }
}

