/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.ImplInclusiveSizeCalculator;
import com.oracle.joverflow.heap.model.JavaBoolean;
import com.oracle.joverflow.heap.model.JavaByte;
import com.oracle.joverflow.heap.model.JavaChar;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaDouble;
import com.oracle.joverflow.heap.model.JavaField;
import com.oracle.joverflow.heap.model.JavaFloat;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaHeapObjectVisitor;
import com.oracle.joverflow.heap.model.JavaInt;
import com.oracle.joverflow.heap.model.JavaLazyReadObject;
import com.oracle.joverflow.heap.model.JavaLong;
import com.oracle.joverflow.heap.model.JavaShort;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.ReadBuffer;
import com.oracle.joverflow.util.MiscUtils;
import com.oracle.joverflow.util.StringInterner;
import java.io.IOException;

public class JavaObject
extends JavaLazyReadObject {
    public JavaObject(JavaClass clazz, long objOfsInFile, int[] dataChunk, int startPosInChunk, int globalObjectIndex) {
        super(clazz, objOfsInFile, dataChunk, startPosInChunk, globalObjectIndex);
    }

    @Override
    public final int getSize() {
        return this.getClazz().getInstanceSize();
    }

    @Override
    public final int getImplInclusiveSize() {
        ImplInclusiveSizeCalculator implSizeCalc = this.getClazz().getImplInclusiveSizeCalculator();
        if (implSizeCalc != null) {
            return implSizeCalc.calculateImplInclusiveSize(this);
        }
        return this.getSize();
    }

    @Override
    public boolean isSameTypeAs(JavaThing other) {
        if (!(other instanceof JavaObject)) {
            return false;
        }
        JavaObject oo = (JavaObject)other;
        return this.getClazz().equals(oo.getClazz());
    }

    public JavaThing[] getFields() {
        return this.parseFields(this.getValue(), true, null);
    }

    public JavaThing[] getFields(JavaThing[] fields) {
        return this.parseFields(this.getValue(), true, fields);
    }

    public JavaThing[] getFields(boolean setPrimitiveFields) {
        return this.parseFields(this.getValue(), setPrimitiveFields, null);
    }

    public JavaThing getField(String name) {
        JavaThing[] flds = this.getFields();
        JavaField[] instFields = this.getClazz().getFieldsForInstance();
        int i = 0;
        while (i < instFields.length) {
            if (instFields[i].getName().equals(name)) {
                return flds[i];
            }
            ++i;
        }
        return null;
    }

    public JavaThing getField(int idx) {
        JavaThing[] fields = this.getFields();
        return fields[idx];
    }

    @Override
    public int compareTo(JavaThing other) {
        if (other instanceof JavaObject) {
            JavaObject oo = (JavaObject)other;
            return this.getClazz().getName().compareTo(oo.getClazz().getName());
        }
        return super.compareTo(other);
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        JavaThing[] flds = this.getFields();
        int i = 0;
        while (i < flds.length) {
            if (!(flds[i] == null || v.mightExclude() && v.exclude(this.getClazz().getDeclaringClassForField(i), this.getClazz().getFieldForInstance(i)) || !(flds[i] instanceof JavaHeapObject))) {
                v.visit((JavaHeapObject)flds[i]);
            }
            ++i;
        }
    }

    public String describeReferenceTo(JavaHeapObject target) {
        JavaThing[] flds = this.getFields();
        int i = 0;
        while (i < flds.length) {
            if (flds[i] == target) {
                JavaField f = this.getClazz().getFieldForInstance(i);
                return "." + f.getName();
            }
            ++i;
        }
        throw new IllegalArgumentException(this + " does not refer to " + target);
    }

    @Override
    public String valueAsString() {
        if (this.getClazz().isString()) {
            String s = this.getClazz().getSnapshot().getStringReader().readString(this);
            if (s != null) {
                return StringInterner.internString(MiscUtils.removeEndLinesAndAddQuotes(s, 0));
            }
            return "null";
        }
        return this.idAsString();
    }

    @Override
    public String toString() {
        return this.valueAsString();
    }

    @Override
    protected final byte[] readValue() throws IOException {
        JavaClass clazz = this.getClazz();
        int length = clazz.getFieldsSizeInFile();
        if (length == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        int idSize = clazz.getHprofPointerSize();
        ReadBuffer buf = clazz.getReadBuffer();
        long offset = this.getObjOfsInFile() + (long)(2 * idSize) + 8L;
        byte[] res = new byte[length];
        buf.get(offset, res);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private JavaThing[] parseFields(byte[] data, boolean setPrimitiveFields, JavaThing[] fieldValues) {
        cl = this.getClazz();
        target = cl.getNumFieldsForInstance();
        reusingFieldArray = false;
        if (fieldValues == null || fieldValues.length != target) {
            fieldValues = new JavaThing[target];
        } else {
            reusingFieldArray = true;
        }
        snapshot = cl.getSnapshot();
        idSize = snapshot.getHprofPointerSize();
        fieldNo = 0;
        fields = cl.getDefinedFields();
        target -= fields.length;
        currClass = cl;
        index = 0;
        i = 0;
        ** GOTO lbl116
        {
            currClass = currClass.getSuperclass();
            fields = currClass.getDefinedFields();
            fieldNo = 0;
            target -= fields.length;
            do {
                block37: {
                    block38: {
                        block36: {
                            if (fieldNo >= fields.length) continue block16;
                            f = fields[fieldNo];
                            fieldValueIdx = target + fieldNo;
                            sig = f.getTypeId();
                            if (sig != 'L' && sig != '[') break block36;
                            id = this.objectIdAt(index, data);
                            index += idSize;
                            fieldValues[fieldValueIdx] = snapshot.dereferenceField(id, f);
                            break block37;
                        }
                        if (!setPrimitiveFields) break block38;
                        switch (sig) {
                            case 'Z': {
                                value = JavaObject.byteAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaBoolean)fieldValues[fieldValueIdx]).setValue(value != 0);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaBoolean(value != 0);
                                }
                                ++index;
                                break block37;
                            }
                            case 'B': {
                                value = JavaObject.byteAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaByte)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaByte(value);
                                }
                                ++index;
                                break block37;
                            }
                            case 'S': {
                                value = JavaObject.shortAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaShort)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaShort(value);
                                }
                                index += 2;
                                break block37;
                            }
                            case 'C': {
                                value = JavaObject.charAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaChar)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaChar(value);
                                }
                                index += 2;
                                break block37;
                            }
                            case 'I': {
                                value = JavaObject.intAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaInt)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaInt(value);
                                }
                                index += 4;
                                break block37;
                            }
                            case 'J': {
                                value = JavaObject.longAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaLong)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaLong(value);
                                }
                                index += 8;
                                break block37;
                            }
                            case 'F': {
                                value = JavaObject.floatAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaFloat)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaFloat(value);
                                }
                                index += 4;
                                break block37;
                            }
                            case 'D': {
                                value = JavaObject.doubleAt(index, data);
                                if (reusingFieldArray) {
                                    ((JavaDouble)fieldValues[fieldValueIdx]).setValue(value);
                                } else {
                                    fieldValues[fieldValueIdx] = new JavaDouble(value);
                                }
                                index += 8;
                                break block37;
                            }
                            default: {
                                throw new RuntimeException("invalid signature: " + sig);
                            }
                        }
                    }
                    switch (sig) {
                        case 'F': 
                        case 'I': {
                            index += 4;
                            break;
                        }
                        case 'B': 
                        case 'Z': {
                            ++index;
                            break;
                        }
                        case 'C': 
                        case 'S': {
                            index += 2;
                            break;
                        }
                        case 'D': 
                        case 'J': {
                            index += 8;
                        }
                    }
                }
                ++i;
                ++fieldNo;
lbl116:
                // 2 sources

            } while (i < fieldValues.length);
        }
        return fieldValues;
    }
}

