/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.parser.DumpCorruptedException;
import com.oracle.joverflow.heap.parser.ReadBuffer;
import java.io.IOException;

public abstract class JavaLazyReadObject
extends JavaHeapObject {
    private static final int VISITED_MASK = Integer.MIN_VALUE;
    private static final int VISITED_COLLECTION_IMPL_MASK = 0x40000000;
    private static final int VISITED_OTHER = 0x20000000;
    protected static final int INTERNAL_ID_MASK = 0x1FFFFFFF;
    protected final JavaClass clazz;
    private final long objOfsInFile;
    private final int[] dataChunk;
    private final int startPosInChunk;
    private final int globalObjectIndex;

    protected JavaLazyReadObject(JavaClass clazz, long objOfsInFile, int[] dataChunk, int startPosInChunk, int globalObjectIndex) {
        this.clazz = clazz;
        this.objOfsInFile = objOfsInFile;
        this.dataChunk = dataChunk;
        this.startPosInChunk = startPosInChunk;
        this.globalObjectIndex = globalObjectIndex;
    }

    @Override
    public final JavaClass getClazz() {
        return this.clazz;
    }

    public final long getObjOfsInFile() {
        return this.objOfsInFile;
    }

    @Override
    public final int getGlobalObjectIndex() {
        return this.globalObjectIndex;
    }

    public final byte[] getValue() {
        try {
            return this.readValue();
        }
        catch (IOException ex) {
            throw new DumpCorruptedException.Runtime("lazy read failed at offset " + this.objOfsInFile + " with exception " + ex);
        }
    }

    @Override
    public final long readId() {
        return this.readId(this.clazz.getReadBuffer(), this.clazz.getHprofPointerSize());
    }

    final long readId(ReadBuffer readBuf, int hprofPointerSize) {
        try {
            if (hprofPointerSize == 4) {
                return (long)readBuf.getInt(this.objOfsInFile) & 0xFFFFFFFFL;
            }
            return readBuf.getLong(this.objOfsInFile);
        }
        catch (IOException ex) {
            throw new DumpCorruptedException.Runtime("lazy read failed at offset " + this.objOfsInFile + " with exception " + ex);
        }
    }

    @Override
    public boolean isVisited() {
        int tagsPos = this.startPosInChunk + 2;
        return (this.dataChunk[tagsPos] & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void setVisited() {
        int tagsPos;
        int n = tagsPos = this.startPosInChunk + 2;
        this.dataChunk[n] = this.dataChunk[n] | Integer.MIN_VALUE;
    }

    @Override
    public boolean setVisitedIfNot() {
        if (this.isVisited()) {
            return false;
        }
        this.setVisited();
        return true;
    }

    static boolean isVisited(int tagWord) {
        return (tagWord & Integer.MIN_VALUE) != 0;
    }

    public boolean isVisitedAsCollectionImpl() {
        int tagsPos = this.startPosInChunk + 2;
        return (this.dataChunk[tagsPos] & 0x40000000) != 0;
    }

    public void setVisitedAsCollectionImpl() {
        int tagsPos;
        int n = tagsPos = this.startPosInChunk + 2;
        this.dataChunk[n] = this.dataChunk[n] | 0x40000000;
    }

    public boolean isVisitedAsOther() {
        int tagsPos = this.startPosInChunk + 2;
        return (this.dataChunk[tagsPos] & 0x20000000) != 0;
    }

    public void setVisitedAsOther() {
        int tagsPos;
        int n = tagsPos = this.startPosInChunk + 2;
        this.dataChunk[n] = this.dataChunk[n] | 0x20000000;
    }

    public int getInternalId() {
        int tagsPos = this.startPosInChunk + 2;
        return this.dataChunk[tagsPos] & 0x1FFFFFFF;
    }

    public void setInternalId(int id) {
        int tagsPos;
        int n = tagsPos = this.startPosInChunk + 2;
        this.dataChunk[n] = this.dataChunk[n] | id;
    }

    protected abstract byte[] readValue() throws IOException;

    protected final long objectIdAt(int index, byte[] data) {
        int idSize = this.getClazz().getHprofPointerSize();
        if (idSize == 4) {
            return (long)JavaLazyReadObject.intAt(index, data) & 0xFFFFFFFFL;
        }
        return JavaLazyReadObject.longAt(index, data);
    }

    protected static byte byteAt(int index, byte[] value) {
        return value[index];
    }

    protected static boolean booleanAt(int index, byte[] value) {
        return (value[index] & 0xFF) != 0;
    }

    protected static char charAt(int index, byte[] value) {
        int b1 = value[index++] & 0xFF;
        int b2 = value[index] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    protected static short shortAt(int index, byte[] value) {
        int b1 = value[index++] & 0xFF;
        int b2 = value[index] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    protected static int intAt(int index, byte[] value) {
        int b1 = value[index++] & 0xFF;
        int b2 = value[index++] & 0xFF;
        int b3 = value[index++] & 0xFF;
        int b4 = value[index] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    protected static long longAt(int index, byte[] value) {
        long val = 0L;
        int j = 0;
        while (j < 8) {
            val <<= 8;
            int b = value[index++] & 0xFF;
            val |= (long)b;
            ++j;
        }
        return val;
    }

    protected static float floatAt(int index, byte[] value) {
        int val = JavaLazyReadObject.intAt(index, value);
        return Float.intBitsToFloat(val);
    }

    protected static double doubleAt(int index, byte[] value) {
        long val = JavaLazyReadObject.longAt(index, value);
        return Double.longBitsToDouble(val);
    }
}

