/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

public class JavaField {
    private final String name;
    private final char typeId;
    private final byte sizeInInstance;
    private static final JavaField[] STATIC_QUAZI_FIELDS = new JavaField[3];

    static {
        JavaField.STATIC_QUAZI_FIELDS[0] = JavaField.newInstance("<signers>", '[', 0);
        JavaField.STATIC_QUAZI_FIELDS[1] = JavaField.newInstance("<protection domain>", 'L', 0);
    }

    public static JavaField newInstance(String name, char typeId, int pointerSize) {
        byte sizeInInstance = 0;
        if (typeId == 'L' || typeId == '[') {
            sizeInInstance = (byte)pointerSize;
        } else {
            switch (typeId) {
                case 'F': 
                case 'I': {
                    sizeInInstance = (byte)4;
                    break;
                }
                case 'B': 
                case 'Z': {
                    sizeInInstance = 1;
                    break;
                }
                case 'C': 
                case 'S': {
                    sizeInInstance = (byte)2;
                    break;
                }
                case 'D': 
                case 'J': {
                    sizeInInstance = (byte)8;
                }
            }
        }
        return new JavaField(name, typeId, sizeInInstance);
    }

    private JavaField(String name, char typeId, byte sizeInInstance) {
        this.name = name;
        this.typeId = typeId;
        this.sizeInInstance = sizeInInstance;
    }

    public boolean isReference() {
        return this.typeId == '[' || this.typeId == 'L';
    }

    public String getName() {
        return this.name;
    }

    public char getTypeId() {
        return this.typeId;
    }

    public int getSizeInInstance() {
        return this.sizeInInstance;
    }

    public static void addStaticQuaziFields(JavaField[] staticFields) {
        System.arraycopy(STATIC_QUAZI_FIELDS, 0, staticFields, staticFields.length - 2, 2);
    }

    public String toString() {
        return String.valueOf(Character.toString(this.typeId)) + ' ' + this.name + " sizeInInstance = " + this.sizeInInstance;
    }
}

