/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.JavaValue;
import com.oracle.joverflow.util.StringInterner;

public class JavaDouble
extends JavaValue {
    private double value;

    public JavaDouble(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    void setValue(double value) {
        this.value = value;
    }

    @Override
    public boolean isZero() {
        return (Double.doubleToLongBits(this.value) & Long.MAX_VALUE) == 0L;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public String valueAsString() {
        return StringInterner.internString(Double.toString(this.value));
    }
}

