/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.JavaValue;
import com.oracle.joverflow.util.StringInterner;

public class JavaByte
extends JavaValue {
    private byte value;

    public JavaByte(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    void setValue(byte value) {
        this.value = value;
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return false;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public String valueAsString() {
        return StringInterner.internString("0x" + Integer.toString(this.value & 0xFF, 16));
    }
}

