/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.heap.model;

import com.oracle.joverflow.heap.model.JavaValue;
import com.oracle.joverflow.util.StringInterner;

public class JavaBoolean
extends JavaValue {
    private boolean value;

    public JavaBoolean(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public boolean isZero() {
        return !this.value;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return false;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public String valueAsString() {
        return StringInterner.internString(Boolean.toString(this.value));
    }

    @Override
    public String toString() {
        return this.valueAsString();
    }
}

