/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.AbstractLinkedCollectionDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.heap.model.UnresolvedObject;

public class TreeMapDescriptor
extends AbstractLinkedCollectionDescriptor {
    private static final JavaHeapObject[] EMPTY_OBJ_ARRAY = new JavaHeapObject[0];
    private int keyFieldIdx;
    private int valueFieldIdx;
    private int leftFieldIdx;
    private int rightFieldIdx;

    private TreeMapDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int doGetImplSize() {
        this.col.setVisitedAsCollectionImpl();
        int result = this.col.getSize();
        JavaThing rootThing = this.col.getField(this.factory.rootFieldIdx);
        if (rootThing == null || rootThing instanceof UnresolvedObject) {
            return result;
        }
        JavaObject rootEntry = (JavaObject)rootThing;
        Factory thisFactory = (Factory)this.factory;
        this.leftFieldIdx = thisFactory.getLeftFieldIdx(rootEntry);
        this.rightFieldIdx = thisFactory.getRightFieldIdx(rootEntry);
        this.keyFieldIdx = thisFactory.getKeyFieldIdx(rootEntry);
        this.valueFieldIdx = thisFactory.getValueFieldIdx(rootEntry);
        return result += this.getDeepEntrySize(rootThing, null);
    }

    private int getDeepEntrySize(JavaThing entryThing, JavaThing[] entryFields) {
        if (entryThing == null || entryThing instanceof UnresolvedObject) {
            return 0;
        }
        JavaObject entry = (JavaObject)entryThing;
        if (entry.isVisitedAsCollectionImpl()) {
            return 0;
        }
        entry.setVisitedAsCollectionImpl();
        entryFields = entry.getFields(entryFields);
        int entrySize = entry.getSize();
        if (entry.isVisited() && entry.getClazz().getSnapshot().isCalculatingStats()) {
            entry.getClazz().updateInclusiveInstanceSize(-entrySize);
        }
        int result = entrySize;
        if (((Factory)this.factory).isJRockitVersion) {
            JavaObjectArray keys = (JavaObjectArray)entryFields[this.keyFieldIdx];
            keys.setVisitedAsCollectionImpl();
            result += keys.getSize();
            JavaObjectArray values = (JavaObjectArray)entryFields[this.valueFieldIdx];
            values.setVisitedAsCollectionImpl();
            result += values.getSize();
        }
        JavaThing leftThing = entryFields[this.leftFieldIdx];
        JavaThing rightThing = entryFields[this.rightFieldIdx];
        result += this.getDeepEntrySize(leftThing, entryFields);
        return result += this.getDeepEntrySize(rightThing, entryFields);
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaThing rootThing = this.col.getField(this.factory.rootFieldIdx);
        if (rootThing == null || !(rootThing instanceof JavaObject)) {
            return;
        }
        JavaObject rootEntry = (JavaObject)rootThing;
        Factory thisFactory = (Factory)this.factory;
        this.keyFieldIdx = thisFactory.getKeyFieldIdx(rootEntry);
        this.valueFieldIdx = thisFactory.getValueFieldIdx(rootEntry);
        this.leftFieldIdx = thisFactory.getLeftFieldIdx(rootEntry);
        this.rightFieldIdx = thisFactory.getRightFieldIdx(rootEntry);
        this.scanEntry(rootEntry, null, cb);
    }

    private void scanEntry(JavaThing entryThing, JavaThing[] entryFields, CollectionInstanceDescriptor.MapIteratorCallback cb) {
        if (entryThing == null || entryThing instanceof UnresolvedObject) {
            return;
        }
        JavaObject entry = (JavaObject)entryThing;
        if (!cb.scanImplementationObject(entry)) {
            return;
        }
        entryFields = entry.getFields(entryFields);
        JavaThing keyThing = entryFields[this.keyFieldIdx];
        JavaThing valueThing = entryFields[this.valueFieldIdx];
        JavaHeapObject key = null;
        JavaHeapObject value = null;
        if (((Factory)this.factory).isJRockitVersion) {
            JavaObjectArray keysArr = keyThing != null && keyThing instanceof JavaObjectArray ? (JavaObjectArray)keyThing : null;
            JavaObjectArray valuesArr = valueThing != null && valueThing instanceof JavaObjectArray ? (JavaObjectArray)valueThing : null;
            JavaHeapObject[] keys = EMPTY_OBJ_ARRAY;
            if (keysArr != null) {
                if (!cb.scanImplementationObject(keysArr)) {
                    return;
                }
                keys = keysArr.getElements();
            }
            JavaHeapObject[] values = EMPTY_OBJ_ARRAY;
            if (valuesArr != null) {
                if (!cb.scanImplementationObject(valuesArr)) {
                    return;
                }
                values = valuesArr.getElements();
            }
            int maxLen = keys.length > values.length ? keys.length : values.length;
            int i = 0;
            while (i < maxLen) {
                key = i < keys.length ? keys[i] : null;
                JavaHeapObject javaHeapObject = value = i < values.length ? values[i] : null;
                if (!cb.scanMapEntry(key, value)) {
                    return;
                }
                ++i;
            }
        } else {
            if (keyThing != null && keyThing instanceof JavaHeapObject) {
                key = (JavaHeapObject)keyThing;
            }
            if (valueThing != null && valueThing instanceof JavaHeapObject) {
                value = (JavaHeapObject)valueThing;
            }
            if (!cb.scanMapEntry(key, value)) {
                return;
            }
        }
        JavaThing leftThing = entryFields[this.leftFieldIdx];
        JavaThing rightThing = entryFields[this.rightFieldIdx];
        this.scanEntry(leftThing, entryFields, cb);
        this.scanEntry(rightThing, entryFields, cb);
    }

    @Override
    protected int getSizeByCountingElements() {
        throw new UnsupportedOperationException("Should never be called");
    }

    /* synthetic */ TreeMapDescriptor(JavaObject javaObject, Factory factory, TreeMapDescriptor treeMapDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends AbstractLinkedCollectionDescriptor.Factory {
        private int leftFieldIdx = -1;
        private int rightFieldIdx = -1;
        private boolean isJRockitVersion;
        private boolean keyFieldIdxInitialized;

        Factory(JavaClass clazz, JavaClass[] implClasses) {
            super(clazz, true, "size", "root", "value", implClasses);
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new TreeMapDescriptor(col, this, null);
        }

        @Override
        protected int getKeyFieldIdx(JavaObject entry) {
            if (this.keyFieldIdxInitialized) {
                return super.getKeyFieldIdx(entry);
            }
            this.keyFieldIdxInitialized = true;
            if (entry.getField("key") != null) {
                this.isJRockitVersion = false;
                return super.getKeyFieldIdx(entry);
            }
            this.isJRockitVersion = true;
            super.setMapKeyFieldName("keys");
            super.setValueFieldName("values");
            return super.getKeyFieldIdx(entry);
        }

        protected int getLeftFieldIdx(JavaObject entry) {
            if (this.leftFieldIdx == -1) {
                this.leftFieldIdx = entry.getClazz().getInstanceFieldIndex("left");
            }
            return this.leftFieldIdx;
        }

        protected int getRightFieldIdx(JavaObject entry) {
            if (this.rightFieldIdx == -1) {
                this.rightFieldIdx = entry.getClazz().getInstanceFieldIndex("right");
            }
            return this.rightFieldIdx;
        }
    }
}

