/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaThing;

public class LinkedHashMapDescriptor
extends ArrayBasedCollectionDescriptor {
    private LinkedHashMapDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int getImplSize() {
        JavaThing headerThing;
        int result = super.getImplSize();
        int idx = ((Factory)this.factory).headerFieldIdx;
        JavaThing javaThing = headerThing = idx != -1 ? this.col.getField(idx) : null;
        if (headerThing == null || !(headerThing instanceof JavaObject)) {
            return result;
        }
        JavaObject header = (JavaObject)headerThing;
        header.setVisitedAsCollectionImpl();
        return result += header.getSize();
    }

    /* synthetic */ LinkedHashMapDescriptor(JavaObject javaObject, Factory factory, LinkedHashMapDescriptor linkedHashMapDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends ArrayBasedCollectionDescriptor.Factory {
        private final int headerFieldIdx;

        Factory(JavaClass clazz, JavaClass[] implClasses, boolean jdk8HashMap) {
            super(clazz, true, "size", "table", 16, implClasses, new String[]{"java.util.LinkedHashSet"}, jdk8HashMap);
            this.headerFieldIdx = jdk8HashMap ? clazz.getInstanceFieldIndexOrMinusOne("head") : clazz.getInstanceFieldIndexOrMinusOne("header");
        }

        Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.headerFieldIdx = ((Factory)superclassFactory).headerFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        ArrayBasedCollectionDescriptor get(JavaObject col) {
            return new LinkedHashMapDescriptor(col, this, null);
        }
    }
}

