/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.util.ClassUtils;

public class IdentityHashMapDescriptor
extends ArrayBasedCollectionDescriptor {
    private IdentityHashMapDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int getImplSize() {
        return this.getDirectImplSize();
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            return;
        }
        if (!cb.scanImplementationObject(elsArray)) {
            return;
        }
        int numElements = this.getNumElements();
        if (numElements == 0) {
            return;
        }
        JavaHeapObject[] elements = elsArray.getElements();
        int idx = 0;
        while (idx < elements.length) {
            JavaHeapObject key = elements[idx++];
            JavaHeapObject value = elements[idx];
            if ((key != null || value != null) && !cb.scanMapEntry(key, value)) break;
            ++idx;
        }
    }

    /* synthetic */ IdentityHashMapDescriptor(JavaObject javaObject, Factory factory, IdentityHashMapDescriptor identityHashMapDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends ArrayBasedCollectionDescriptor.Factory {
        Factory(JavaClass clazz) {
            super(clazz, true, "size", ClassUtils.getExactFieldName("table|elementData", clazz), 32, new JavaClass[0], null);
        }

        Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        ArrayBasedCollectionDescriptor get(JavaObject col) {
            return new IdentityHashMapDescriptor(col, this, null);
        }
    }
}

