/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.support.Constants;
import com.oracle.joverflow.util.ClassUtils;

public class HashSetDescriptor
extends AbstractCollectionDescriptor
implements CollectionInstanceDescriptor.CapacityDifferentFromSize,
Constants {
    private final Factory factory;
    private final ArrayBasedCollectionDescriptor mapDesc;

    private HashSetDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
        JavaThing mapField = this.fields[factory.mapFieldIdx];
        if (mapField == null || !(mapField instanceof JavaObject)) {
            this.mapDesc = null;
            return;
        }
        JavaObject map = (JavaObject)mapField;
        this.mapDesc = factory.hashMapDescFactory.get(map);
    }

    @Override
    public int getNumElements() {
        return this.mapDesc != null ? this.mapDesc.getNumElements() : 0;
    }

    @Override
    public void iterateList(final CollectionInstanceDescriptor.ListIteratorCallback cb) {
        if (this.mapDesc == null) {
            return;
        }
        this.mapDesc.iterateMap(new CollectionInstanceDescriptor.MapIteratorCallback(){

            @Override
            public boolean scanMapEntry(JavaHeapObject key, JavaHeapObject value) {
                return cb.scanListElement(key);
            }

            @Override
            public boolean scanImplementationObject(JavaHeapObject implObj) {
                return cb.scanImplementationObject(implObj);
            }
        });
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int doGetImplSize() {
        if (this.mapDesc == null) {
            return this.col.getSize();
        }
        this.mapDesc.col.setVisitedAsCollectionImpl();
        return this.col.getSize() + (this.mapDesc != null ? this.mapDesc.getImplSize() : 0);
    }

    @Override
    public int getSparsenessOverhead(int ptrSize) {
        if (this.mapDesc == null) {
            return 0;
        }
        return this.mapDesc.getSparsenessOverhead(ptrSize);
    }

    @Override
    public int getDefaultCapacity() {
        return this.mapDesc != null ? this.mapDesc.getDefaultCapacity() : 16;
    }

    @Override
    public int getCapacity() {
        return this.mapDesc != null ? this.mapDesc.getCapacity() : 0;
    }

    @Override
    public long getModCount() {
        return this.mapDesc != null ? this.mapDesc.getModCount() : 0L;
    }

    @Override
    AbstractCollectionDescriptor.Factory getFactory() {
        return this.factory;
    }

    /* synthetic */ HashSetDescriptor(JavaObject javaObject, Factory factory, HashSetDescriptor hashSetDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends AbstractCollectionDescriptor.Factory {
        private static final String MAP_FIELD_NAMES = "map|backingMap";
        private final int mapFieldIdx;
        private final ArrayBasedCollectionDescriptor.Factory hashMapDescFactory;

        Factory(JavaClass hashSetClazz, JavaClass[] implClasses, ArrayBasedCollectionDescriptor.Factory hashMapDescFactory) {
            super(hashSetClazz, false, implClasses, null, true, new String[0]);
            this.hashMapDescFactory = hashMapDescFactory;
            String mapFieldName = ClassUtils.getExactFieldName(MAP_FIELD_NAMES, hashSetClazz);
            this.mapFieldIdx = hashSetClazz.getInstanceFieldIndex(mapFieldName);
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.hashMapDescFactory = ((Factory)superclassFactory).hashMapDescFactory;
            this.mapFieldIdx = ((Factory)superclassFactory).mapFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new HashSetDescriptor(col, this, null);
        }

        @Override
        protected boolean setModCountFieldIdx(JavaClass clazz) {
            return true;
        }
    }
}

