/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;
import com.oracle.joverflow.heap.model.JavaThing;

class FullyUtilizedArrayListDescriptor
extends AbstractCollectionDescriptor {
    protected final Factory factory;

    FullyUtilizedArrayListDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
    }

    @Override
    public int getNumElements() {
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            return 0;
        }
        return elsArray.getLength();
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        JavaHeapObject[] elements;
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            return;
        }
        if (!cb.scanImplementationObject(elsArray)) {
            return;
        }
        JavaHeapObject[] javaHeapObjectArray = elements = elsArray.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (element != null && !cb.scanListElement(element)) break;
            ++n2;
        }
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int doGetImplSize() {
        return this.getDirectImplSize();
    }

    @Override
    AbstractCollectionDescriptor.Factory getFactory() {
        return this.factory;
    }

    public JavaObjectArray getElementsArray() {
        JavaThing els = this.fields[this.factory.elsArrayFieldIdx];
        return els instanceof JavaObjectArray ? (JavaObjectArray)els : null;
    }

    protected int getDirectImplSize() {
        this.col.setVisitedAsCollectionImpl();
        int colSize = this.col.getSize();
        JavaObjectArray els = this.getElementsArray();
        if (els == null) {
            return colSize;
        }
        els.setVisitedAsCollectionImpl();
        return colSize + els.getSize();
    }

    static class Factory
    extends AbstractCollectionDescriptor.Factory {
        private final int elsArrayFieldIdx;

        Factory(JavaClass clazz, String elsArrayFieldName, JavaClass[] implClasses, String[] parentColClassNames) {
            super(clazz, false, implClasses, parentColClassNames, false, new String[]{elsArrayFieldName});
            this.elsArrayFieldIdx = clazz.getInstanceFieldIndex(elsArrayFieldName);
        }

        Factory(JavaClass clazz, Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.elsArrayFieldIdx = superclassFactory.elsArrayFieldIdx;
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new FullyUtilizedArrayListDescriptor(col, this);
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }
    }
}

