/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.heap.model.CollectionClassProperties;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.support.Constants;

public class CollectionClassDescriptor
implements CollectionClassProperties {
    private final JavaClass clazz;
    private final boolean isMap;
    private final boolean canDetermineModCount;
    private final boolean hasOtherCollectionInImpl;
    private final String[] implClassNames;
    private final String[] parentColClassNames;
    private static final int NUM_ANTIPATTERNS = Constants.ProblemKind.values().length;
    private int[] nProblematicCols = new int[NUM_ANTIPATTERNS];
    private int[] problematicColsOverhead = new int[NUM_ANTIPATTERNS];

    CollectionClassDescriptor(JavaClass clazz, boolean isMap, boolean canDetermineModCount, JavaClass[] implClasses, String[] parentColClassNames, boolean hasOtherCollectionInImpl) {
        this(clazz, isMap, canDetermineModCount, CollectionClassDescriptor.getImplClassNames(implClasses), parentColClassNames, hasOtherCollectionInImpl);
    }

    CollectionClassDescriptor cloneForSubclass(JavaClass subClazz) {
        return new CollectionClassDescriptor(subClazz, this.isMap, this.canDetermineModCount, this.implClassNames, this.parentColClassNames, this.hasOtherCollectionInImpl);
    }

    private CollectionClassDescriptor(JavaClass clazz, boolean isMap, boolean canDetermineModCount, String[] implClassNames, String[] parentColClassNames, boolean hasOtherCollectionInImpl) {
        this.clazz = clazz;
        this.isMap = isMap;
        this.canDetermineModCount = canDetermineModCount;
        this.implClassNames = implClassNames;
        this.parentColClassNames = parentColClassNames;
        this.hasOtherCollectionInImpl = hasOtherCollectionInImpl;
        if (!clazz.isArray()) {
            clazz.setCollectionClassProperties(this);
        }
    }

    public JavaClass getClazz() {
        return this.clazz;
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    @Override
    public boolean isMap() {
        return this.isMap;
    }

    @Override
    public boolean hasOtherCollectionInImpl() {
        return this.hasOtherCollectionInImpl;
    }

    public boolean canDetermineModCount() {
        return this.canDetermineModCount;
    }

    public boolean isImplClassName(String className) {
        if (this.implClassNames == null) {
            return false;
        }
        String[] stringArray = this.implClassNames;
        int n = this.implClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String implClassName = stringArray[n2];
            if (className.equals(implClassName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isInImplementationOf(String className) {
        if (this.parentColClassNames == null) {
            return false;
        }
        String[] stringArray = this.parentColClassNames;
        int n = this.parentColClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parentColClassName = stringArray[n2];
            if (className.equals(parentColClassName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPrimitiveArray() {
        return this.clazz.isAnyDimPrimitiveArray();
    }

    public void addProblematicCollection(Constants.ProblemKind kind, int ovhd) {
        int kindIdx;
        int n = kindIdx = kind.ordinal();
        this.nProblematicCols[n] = this.nProblematicCols[n] + 1;
        int n2 = kindIdx;
        this.problematicColsOverhead[n2] = this.problematicColsOverhead[n2] + ovhd;
    }

    public int getNumProblematicCollections(Constants.ProblemKind kind) {
        return this.nProblematicCols[kind.ordinal()];
    }

    public int getProblematicCollectionsOverhead(Constants.ProblemKind kind) {
        return this.problematicColsOverhead[kind.ordinal()];
    }

    public long getTotalOverhead() {
        long totalOvhd = 0L;
        Constants.ProblemKind[] problemKindArray = Constants.ProblemKind.values();
        int n = problemKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constants.ProblemKind kind = problemKindArray[n2];
            totalOvhd += (long)this.getProblematicCollectionsOverhead(kind);
            ++n2;
        }
        return totalOvhd;
    }

    public String toString() {
        return this.clazz.getName();
    }

    private static String[] getImplClassNames(JavaClass[] implClasses) {
        String[] implClassNames = new String[implClasses.length];
        int i = 0;
        while (i < implClasses.length) {
            implClassNames[i] = implClasses[i].getName();
            ++i;
        }
        return implClassNames;
    }
}

