/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaInt;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaObjectArray;

public class ArrayDequeDescriptor
extends AbstractArrayBasedCollectionDescriptor {
    private int numElements = -1;

    ArrayDequeDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int getNumElements() {
        if (this.numElements != -1) {
            return this.numElements;
        }
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            this.numElements = 0;
            return this.numElements;
        }
        Factory f = (Factory)this.factory;
        int tail = ((JavaInt)this.fields[f.tailFieldIdx]).getValue();
        int head = ((JavaInt)this.fields[f.headFieldIdx]).getValue();
        this.numElements = tail - head & elsArray.getLength() - 1;
        return this.numElements;
    }

    @Override
    public int doGetImplSize() {
        return this.getDirectImplSize();
    }

    static class Factory
    extends AbstractArrayBasedCollectionDescriptor.Factory {
        private final int headFieldIdx;
        private final int tailFieldIdx;

        Factory(JavaClass clazz) {
            super(clazz, false, "elements", 16, new JavaClass[0], null);
            this.headFieldIdx = clazz.getInstanceFieldIndex("head");
            this.tailFieldIdx = clazz.getInstanceFieldIndex("tail");
        }

        private Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.headFieldIdx = ((Factory)superclassFactory).headFieldIdx;
            this.tailFieldIdx = ((Factory)superclassFactory).tailFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new ArrayDequeDescriptor(col, this);
        }
    }
}

