/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.AbstractCollectionDescriptor;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaInt;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.support.Constants;
import com.oracle.joverflow.util.ClassUtils;

public abstract class AbstractLinkedCollectionDescriptor
extends AbstractCollectionDescriptor
implements Constants {
    protected final Factory factory;

    protected AbstractLinkedCollectionDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
    }

    @Override
    public int getNumElements() {
        if (this.factory.sizeFieldIdx != -1) {
            return ((JavaInt)this.fields[this.factory.sizeFieldIdx]).getValue();
        }
        return this.getSizeByCountingElements();
    }

    @Override
    AbstractCollectionDescriptor.Factory getFactory() {
        return this.factory;
    }

    protected abstract int getSizeByCountingElements();

    static abstract class Factory
    extends AbstractCollectionDescriptor.Factory {
        protected final int sizeFieldIdx;
        protected final int rootFieldIdx;
        private final String elementFieldName;
        private int elementFieldIdx = -1;

        Factory(JavaClass clazz, boolean isMap, String sizeFieldName, String rootFieldName, String elementFieldName, JavaClass[] implClasses) {
            super(clazz, isMap, implClasses, null, false, new String[]{rootFieldName});
            this.sizeFieldIdx = sizeFieldName != null ? clazz.getInstanceFieldIndex(sizeFieldName) : -1;
            this.rootFieldIdx = clazz.getInstanceFieldIndex(rootFieldName);
            this.elementFieldName = elementFieldName;
        }

        protected Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.sizeFieldIdx = ((Factory)superclassFactory).sizeFieldIdx;
            this.rootFieldIdx = ((Factory)superclassFactory).rootFieldIdx;
            this.elementFieldName = ((Factory)superclassFactory).elementFieldName;
        }

        protected int getElementFieldIdx(JavaObject entry) {
            if (this.elementFieldIdx == -1) {
                JavaClass entryClass = entry.getClazz();
                String elFieldName = ClassUtils.getExactFieldName(this.elementFieldName, entryClass);
                this.elementFieldIdx = entry.getClazz().getInstanceFieldIndex(elFieldName);
            }
            return this.elementFieldIdx;
        }
    }
}

