/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow.descriptors;

import com.oracle.joverflow.descriptors.CollectionClassDescriptor;
import com.oracle.joverflow.descriptors.CollectionInstanceDescriptor;
import com.oracle.joverflow.heap.model.ImplInclusiveSizeCalculator;
import com.oracle.joverflow.heap.model.JavaClass;
import com.oracle.joverflow.heap.model.JavaField;
import com.oracle.joverflow.heap.model.JavaHeapObject;
import com.oracle.joverflow.heap.model.JavaInt;
import com.oracle.joverflow.heap.model.JavaLong;
import com.oracle.joverflow.heap.model.JavaObject;
import com.oracle.joverflow.heap.model.JavaThing;
import com.oracle.joverflow.util.IntArrayList;

abstract class AbstractCollectionDescriptor
implements CollectionInstanceDescriptor {
    protected final JavaObject col;
    protected final JavaThing[] fields;
    private int implInclusiveSize = -1;

    AbstractCollectionDescriptor(JavaObject col) {
        this.col = col;
        this.fields = col.getFields();
    }

    @Override
    public CollectionClassDescriptor getClassDescriptor() {
        return this.getFactory().classDesc;
    }

    @Override
    public int getImplSize() {
        if (this.implInclusiveSize == -1) {
            this.implInclusiveSize = this.doGetImplSize();
        }
        return this.implInclusiveSize;
    }

    protected abstract int doGetImplSize();

    abstract Factory getFactory();

    @Override
    public long getModCount() {
        Factory factory = this.getFactory();
        int modCountFieldIdx = factory.modCountFieldIdx;
        if (modCountFieldIdx == -1) {
            throw new RuntimeException("There is no modCount field in class " + factory.classDesc.getClassName());
        }
        JavaThing modCountField = this.fields[modCountFieldIdx];
        if (modCountField instanceof JavaLong) {
            return ((JavaLong)modCountField).getValue();
        }
        return ((JavaInt)modCountField).getValue();
    }

    @Override
    public final JavaHeapObject getSampleElement() {
        class ListSampler
        implements CollectionInstanceDescriptor.ListIteratorCallback {
            JavaHeapObject sampleElement;
            private int counter;

            ListSampler() {
            }

            @Override
            public boolean scanListElement(JavaHeapObject element) {
                ++this.counter;
                if (element == null) {
                    return this.counter < 3;
                }
                if (this.counter == 1) {
                    this.sampleElement = element;
                } else if (this.sampleElement != null && element.getClazz() == this.sampleElement.getClazz()) {
                    this.sampleElement = element;
                } else {
                    this.sampleElement = null;
                    return false;
                }
                return this.counter < 3;
            }

            @Override
            public boolean scanImplementationObject(JavaHeapObject implObj) {
                return true;
            }
        }
        ListSampler listSampler = new ListSampler();
        this.iterateList(listSampler);
        return listSampler.sampleElement;
    }

    @Override
    public final JavaHeapObject[] getSampleKeyAndValue() {
        class MapSampler
        implements CollectionInstanceDescriptor.MapIteratorCallback {
            JavaHeapObject sampleKey;
            JavaHeapObject sampleValue;
            private int counter;

            MapSampler() {
            }

            @Override
            public boolean scanMapEntry(JavaHeapObject key, JavaHeapObject value) {
                ++this.counter;
                if (this.counter == 1) {
                    this.sampleKey = key;
                    this.sampleValue = value;
                } else {
                    if (key != null) {
                        this.sampleKey = this.sampleKey != null && key.getClazz() == this.sampleKey.getClazz() ? key : null;
                    }
                    if (value != null) {
                        this.sampleValue = this.sampleValue != null && value.getClazz() == this.sampleValue.getClazz() ? value : null;
                    }
                }
                return this.counter < 3;
            }

            @Override
            public boolean scanImplementationObject(JavaHeapObject implObj) {
                return true;
            }
        }
        MapSampler cb = new MapSampler();
        this.iterateMap(cb);
        return new JavaHeapObject[]{cb.sampleKey, cb.sampleValue};
    }

    @Override
    public final boolean hasExtraObjFields() {
        return this.getFactory().knownAndPrimitiveFieldIndices != null;
    }

    @Override
    public final void filterExtraObjFields(JavaThing[] fields) {
        int[] knownAndPrimitiveFieldIndices;
        int[] nArray = knownAndPrimitiveFieldIndices = this.getFactory().knownAndPrimitiveFieldIndices;
        int n = knownAndPrimitiveFieldIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int idx = nArray[n2];
            fields[idx] = null;
            ++n2;
        }
    }

    private static int[] getKnownAndPrimitiveFieldIndices(JavaClass clazz, String[] knownObjFieldNames) {
        int n;
        int n2;
        Object[] objectArray;
        JavaField[] fields = clazz.getFieldsForInstance();
        int[] bannedFieldIndices = clazz.getBannedFieldIndices();
        if (bannedFieldIndices != null) {
            objectArray = bannedFieldIndices;
            n2 = bannedFieldIndices.length;
            n = 0;
            while (n < n2) {
                int bannedFieldIdx = objectArray[n];
                fields[bannedFieldIdx] = null;
                ++n;
            }
        }
        objectArray = knownObjFieldNames;
        n2 = knownObjFieldNames.length;
        n = 0;
        while (n < n2) {
            int knownFieldName = objectArray[n];
            int i = fields.length - 1;
            while (i >= 0) {
                if (fields[i] != null && fields[i].getName().equals(knownFieldName)) {
                    fields[i] = null;
                    break;
                }
                --i;
            }
            ++n;
        }
        int i = 0;
        while (i < fields.length) {
            if (fields[i] != null && !fields[i].isReference()) {
                fields[i] = null;
            }
            ++i;
        }
        IntArrayList ia = new IntArrayList(fields.length);
        int i2 = 0;
        while (i2 < fields.length) {
            if (fields[i2] == null) {
                ia.add(i2);
            }
            ++i2;
        }
        if (ia.size() == fields.length) {
            return null;
        }
        return ia.toArray();
    }

    static abstract class Factory
    implements ImplInclusiveSizeCalculator {
        protected final CollectionClassDescriptor classDesc;
        private String keyFieldName = "key";
        private String valueFieldName = "value";
        private int keyFieldIdx = -1;
        private int valueFieldIdx = -1;
        private int modCountFieldIdx = -1;
        private int entryNextFieldIdx = -1;
        protected final int[] knownAndPrimitiveFieldIndices;

        abstract CollectionInstanceDescriptor get(JavaObject var1);

        CollectionClassDescriptor getClassDescriptor() {
            return this.classDesc;
        }

        Factory(JavaClass clazz, boolean isMap, JavaClass[] implClasses, String[] parentColClassNames, boolean hasOtherCollectionInImpl, String[] knownObjFieldNames) {
            boolean canDetermineModCount = this.setModCountFieldIdx(clazz);
            this.knownAndPrimitiveFieldIndices = knownObjFieldNames != null ? AbstractCollectionDescriptor.getKnownAndPrimitiveFieldIndices(clazz, knownObjFieldNames) : null;
            this.classDesc = new CollectionClassDescriptor(clazz, isMap, canDetermineModCount, implClasses, parentColClassNames, hasOtherCollectionInImpl);
            clazz.setImplInclusiveSizeCalculator(this);
        }

        Factory(JavaClass clazz, Factory superclassFactory) {
            this.classDesc = superclassFactory.classDesc.cloneForSubclass(clazz);
            this.keyFieldName = superclassFactory.keyFieldName;
            this.keyFieldIdx = superclassFactory.keyFieldIdx;
            this.valueFieldIdx = superclassFactory.valueFieldIdx;
            this.modCountFieldIdx = superclassFactory.modCountFieldIdx;
            this.knownAndPrimitiveFieldIndices = superclassFactory.knownAndPrimitiveFieldIndices;
            clazz.setImplInclusiveSizeCalculator(this);
        }

        abstract Factory cloneForSubclass(JavaClass var1);

        @Override
        public int calculateImplInclusiveSize(JavaObject javaObj) {
            CollectionInstanceDescriptor colDesc = this.get(javaObj);
            return colDesc.getImplSize();
        }

        protected int getEntryNextFieldIdx(JavaThing[] entries) {
            if (this.entryNextFieldIdx == -1) {
                JavaThing[] javaThingArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaThing entry = javaThingArray[n2];
                    if (entry != null && entry instanceof JavaObject) {
                        this.entryNextFieldIdx = this.getEntryNextFieldIdx((JavaObject)entry);
                        break;
                    }
                    ++n2;
                }
            }
            if (this.entryNextFieldIdx == -1) {
                return -1;
            }
            return this.entryNextFieldIdx;
        }

        protected int getEntryNextFieldIdx(JavaObject entry) {
            if (this.entryNextFieldIdx == -1) {
                JavaClass entryClazz = entry.getClazz();
                JavaField[] fieldDescs = entryClazz.getFieldsForInstance();
                int i = fieldDescs.length - 1;
                while (i >= 0) {
                    if ("next".equals(fieldDescs[i].getName())) {
                        this.entryNextFieldIdx = i;
                        break;
                    }
                    --i;
                }
            }
            return this.entryNextFieldIdx;
        }

        void setMapKeyFieldName(String keyFieldName) {
            this.keyFieldName = keyFieldName;
        }

        void setValueFieldName(String valueFieldName) {
            this.valueFieldName = valueFieldName;
        }

        protected int getKeyFieldIdx(JavaObject entry) {
            if (this.keyFieldIdx == -1) {
                this.keyFieldIdx = entry.getClazz().getInstanceFieldIndex(this.keyFieldName);
            }
            return this.keyFieldIdx;
        }

        protected int getValueFieldIdx(JavaObject entry) {
            if (this.valueFieldIdx == -1) {
                this.valueFieldIdx = entry.getClazz().getInstanceFieldIndex(this.valueFieldName);
            }
            return this.valueFieldIdx;
        }

        protected boolean setModCountFieldIdx(JavaClass clazz) {
            this.modCountFieldIdx = clazz.getInstanceFieldIndexOrMinusOne("modCount");
            if (this.modCountFieldIdx != -1) {
                JavaField modCountField = clazz.getFieldForInstance(this.modCountFieldIdx);
                if (modCountField != null) {
                    char modCountFieldType = modCountField.getTypeId();
                    if (modCountFieldType != 'J' && modCountFieldType != 'I') {
                        this.modCountFieldIdx = -1;
                    }
                } else {
                    this.modCountFieldIdx = -1;
                }
            }
            return this.modCountFieldIdx != -1;
        }
    }
}

