/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow;

import com.oracle.joverflow.batch.BatchProblemRecorder;
import com.oracle.joverflow.batch.DetailedStats;
import com.oracle.joverflow.batch.ReportFormatter;
import com.oracle.joverflow.heap.model.Snapshot;
import com.oracle.joverflow.heap.parser.DumpCorruptedException;
import com.oracle.joverflow.heap.parser.HeapDumpReader;
import com.oracle.joverflow.heap.parser.HprofParsingCancelledException;
import com.oracle.joverflow.heap.parser.ReadBuffer;
import com.oracle.joverflow.stats.StandardStatsCalculator;
import com.oracle.joverflow.support.HeapStats;
import com.oracle.joverflow.util.FileUtils;
import com.oracle.joverflow.util.ProgressMeter;
import com.oracle.joverflow.util.VerboseOutputCollector;
import java.io.IOException;

public class ReportGenerator {
    public static final boolean DEFAULT_USE_BREADTH_FIRST_SCAN = false;
    public static final boolean DEFAULT_PRINT_FULL_OBJ_HISTO = false;
    public static final int DEFAULT_PRINTED_REF_CHAIN_DEPTH = 8;
    public static final String[] DEFAULT_REF_CHAIN_STOPPER_CLASS_PREFIXES = new String[]{"oracle.apps."};
    private ReportFormatter reportFormatter;
    private volatile HeapDumpReader reader;
    private volatile StandardStatsCalculator ssc;

    public static ReportGenerator parseDump(String hprofFile, Progress progress, boolean useBreadthFirstScan) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        FileUtils.checkFileExistsAndReadable(hprofFile, false);
        return new ReportGenerator(hprofFile, progress, useBreadthFirstScan);
    }

    public String getReport() {
        return this.getReport(false, 8, DEFAULT_REF_CHAIN_STOPPER_CLASS_PREFIXES);
    }

    public String getReport(boolean printFullClassHistogram, int printedRefChainDepth, String[] refChainStopperClassPrefixes) {
        return this.reportFormatter.getReport(printFullClassHistogram, printedRefChainDepth, refChainStopperClassPrefixes);
    }

    private ReportGenerator(String hprofFile, Progress progress, boolean useBreadthFirstScan) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        CallbackProgressMeter pm = null;
        if (progress != null) {
            progress.setReportGenerator(this);
            pm = new CallbackProgressMeter(progress);
            pm.start();
        }
        Snapshot snapshot = this.readSnapshot(hprofFile);
        BatchProblemRecorder recorder = new BatchProblemRecorder();
        this.ssc = new StandardStatsCalculator(snapshot, recorder, useBreadthFirstScan);
        HeapStats hs = this.ssc.calculate();
        this.ssc = null;
        int minOvhdToReport = (int)hs.totalObjSize / 1000;
        DetailedStats ds = recorder.getDetailedStats(minOvhdToReport);
        if (pm != null) {
            pm.stopReporting();
        }
        this.reportFormatter = new ReportFormatter(hs, ds);
    }

    private Snapshot readSnapshot(String fileName) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        VerboseOutputCollector vc = new VerboseOutputCollector();
        this.reader = HeapDumpReader.createReader(new ReadBuffer.CachedReadBufferFactory(fileName, 0), 0, vc);
        Snapshot snapshot = this.reader.read();
        this.reader = null;
        return snapshot;
    }

    private class CallbackProgressMeter
    extends ProgressMeter {
        private final Progress pc;
        private int prevReadPercent;
        private int prevAnalyzePercent;

        CallbackProgressMeter(Progress pc) {
            this.pc = pc;
        }

        @Override
        public int queryPercentage() {
            int readPercent = this.prevReadPercent;
            int analyzePercent = this.prevAnalyzePercent;
            HeapDumpReader localReader = ReportGenerator.this.reader;
            if (localReader != null) {
                this.prevReadPercent = readPercent = localReader.getProgressPercentage();
            } else if (this.prevReadPercent > 0) {
                readPercent = 100;
            }
            StandardStatsCalculator localSsc = ReportGenerator.this.ssc;
            if (localSsc != null) {
                this.prevAnalyzePercent = analyzePercent = localSsc.getProgressPercentage();
            }
            return readPercent / 3 + analyzePercent * 2 / 3;
        }

        @Override
        public void reportProgress(int progressPerecentage) {
            this.pc.reportProgress(progressPerecentage);
        }
    }

    public static abstract class Progress {
        private ReportGenerator rg;

        public abstract void reportProgress(int var1);

        public void cancel() {
            StandardStatsCalculator localSsc;
            ReportGenerator localRg = this.rg;
            if (localRg == null) {
                return;
            }
            HeapDumpReader localReader = localRg.reader;
            if (localReader != null) {
                localReader.cancelReading();
            }
            if ((localSsc = localRg.ssc) != null) {
                localSsc.cancelCalculation();
            }
        }

        private void setReportGenerator(ReportGenerator rg) {
            this.rg = rg;
        }
    }
}

