/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.joverflow;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class PhoneHome {
    private static final String HOST = "http://oraclelabs.us.oracle.com";
    private static final String SCRIPT_URL = "http://oraclelabs.us.oracle.com/people/misha/joverflow-www/register-run.php";
    private static final String DOWNLOAD = "/people/misha/bin/tools.zip";
    private static final String VERSION = "Version ";
    private static final int MAX_FILENAME_LEN = 32;
    private static final int TIMEOUT_MS = 4000;

    public static void call(String versionId, String fileName, long fileSize) {
        new PhoneHome().doCall(versionId, fileName, fileSize);
    }

    private void doCall(String versionId, String fileName, long fileSize) {
        String user = System.getProperty("user.name");
        if (user.equals("mdmitrie") || user.equals("misha") || user.equals("md85230")) {
            return;
        }
        int lastSlashIdx = fileName.lastIndexOf(47);
        if (lastSlashIdx != -1) {
            fileName = fileName.substring(lastSlashIdx + 1);
        }
        if ((lastSlashIdx = fileName.lastIndexOf(92)) != -1) {
            fileName = fileName.substring(lastSlashIdx + 1);
        }
        if (fileName.length() > 32) {
            fileName = String.valueOf(fileName.substring(0, 32)) + "...";
        }
        int fileSizeInM = (int)(fileSize / 1024L / 1024L);
        String scriptParams = "?user=" + user + ",version=" + versionId + ",file_name=" + fileName + ",file_size=" + fileSizeInM + "M";
        try {
            String responseLine;
            BufferedReader in = this.connectToUrl(SCRIPT_URL + scriptParams);
            while ((responseLine = in.readLine()) != null) {
                String expectedResponse;
                if (!responseLine.startsWith(VERSION) || responseLine.equals(expectedResponse = VERSION + versionId) || responseLine.compareTo(expectedResponse) <= 0) continue;
                System.err.println("Note: a newer version of JOverflow is available: " + responseLine);
                System.err.println("Please check http://oraclelabs.us.oracle.com/people/misha/bin/tools.zip");
            }
            in.close();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            System.err.println("Warning: could not contact http://oraclelabs.us.oracle.com to check for a new JOverflow version:");
            System.err.println(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedReader connectToUrl(String urlString) throws IOException {
        ConnectThread ct = new ConnectThread(urlString);
        ct.setDaemon(true);
        ct.start();
        ConnectThread connectThread = ct;
        synchronized (connectThread) {
            long startTime = System.currentTimeMillis();
            while (ct.result == null && ct.exception == null && System.currentTimeMillis() < startTime + 4000L) {
                try {
                    ct.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (ct.result != null) {
            return ct.result;
        }
        if (ct.exception != null) {
            throw ct.exception;
        }
        throw new IOException("Connection time out");
    }

    private static class ConnectThread
    extends Thread {
        private final String urlString;
        BufferedReader result;
        IOException exception;

        ConnectThread(String urlString) {
            this.urlString = urlString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    try {
                        URL url = new URL(this.urlString);
                        URLConnection conn = url.openConnection();
                        conn.setConnectTimeout(3500);
                        conn.connect();
                        this.result = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    }
                    catch (IOException ex) {
                        this.exception = ex;
                        ConnectThread connectThread = this;
                        synchronized (connectThread) {
                            this.notifyAll();
                            break block14;
                        }
                    }
                }
                catch (Throwable throwable) {
                    ConnectThread connectThread = this;
                    synchronized (connectThread) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this.notifyAll();
                }
            }
        }
    }
}

