/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard.process;

import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.ui.wizard.process.ProcessInput;
import com.jrockit.mc.dtrace.ui.wizard.process.ProcessLabelProvider;
import com.jrockit.mc.ui.misc.ToolTipManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormText;

final class WrappedCmdlineTooltipProvider
extends ProcessLabelProvider
implements ToolTipManager.ToolTipProvider {
    private static final int CMDLINE_TOOLTIP_ROW_LENGTH = 60;
    private final ProcessInput m_processInput;

    public WrappedCmdlineTooltipProvider(ProcessInput processInput) {
        this.m_processInput = processInput;
    }

    public boolean initializeToolTip(FormText text, int x, int y) {
        ProcessDescriptor pd = this.m_processInput.getSelectedProcess();
        if (pd != null) {
            String wrappedCmdline = StringToolkit.wrapString((String)this.getTooltipDescription(pd), (int)60, (String)" ", (String)"<br/>");
            Image img = this.getImage(pd);
            if (img != null) {
                text.setImage("appicon", img);
            }
            text.setText("<form><p><img href=\"appicon\"/> <b>PID=" + pd.getIdentifier() + "</b><br/>" + wrappedCmdline + "</p></form>", true, false);
            return true;
        }
        return false;
    }

    private String getTooltipDescription(ProcessDescriptor pd) {
        return String.valueOf(pd.getPath()) + "/" + pd.getExecutable() + " " + pd.getArguments();
    }
}

