/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard.process;

import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.core.labelingrules.NameConverter;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class ProcessLabelProvider
extends LabelProvider {
    private LocalResourceManager localResourceManager;

    ProcessLabelProvider() {
    }

    public String getText(Object element) {
        String description = this.getNamingConverterDescription((ProcessDescriptor)element);
        if (description == null) {
            description = this.createApplicationDescription((ProcessDescriptor)element);
        }
        return description;
    }

    public Image getImage(Object element) {
        Resource resource = NameConverter.getInstance().getImageResource(((ProcessDescriptor)element).toJVMDescriptor());
        if (resource != null) {
            ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)resource.getPluginID(), (String)resource.getResourcePath());
            return (Image)this.getResourceManager().get((DeviceResourceDescriptor)image);
        }
        return null;
    }

    private String createApplicationDescription(ProcessDescriptor pd) {
        String text = String.valueOf(pd.getExecutable()) + ' ';
        text = pd.getArguments().length() > 30 ? String.valueOf(text) + pd.getArguments().substring(0, 27) + "..." : String.valueOf(text) + pd.getArguments();
        return String.valueOf(text) + " (PID=" + pd.getIdentifier() + ")";
    }

    private String getNamingConverterDescription(ProcessDescriptor pd) {
        return NameConverter.getInstance().format(pd.toJVMDescriptor());
    }

    protected LocalResourceManager getResourceManager() {
        if (this.localResourceManager == null) {
            this.localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.localResourceManager;
    }
}

