/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard.process;

import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.ProcessDescriptor;
import com.jrockit.mc.dtrace.ui.wizard.process.DTraceProcessDecorator;
import com.jrockit.mc.dtrace.ui.wizard.process.ProcessLabelProvider;
import com.jrockit.mc.dtrace.ui.wizard.process.WrappedCmdlineTooltipProvider;
import com.jrockit.mc.ui.misc.ToolTipManager;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public final class ProcessInput
extends Input {
    private static final int VISIBLE_ITEM_COUNT = 10;
    private static final String DTRACE_MONITOR_PROBES_FLAG = "-XX:+DTraceMonitorProbes";
    private static final String EXTENDED_DTRACE_PROBES_FLAG = "-XX:+ExtendedDTraceProbes";
    private static final String APPLICATION = "application";
    private final DTraceRecorder m_recorder;
    private final Integer m_defaultPid;
    private final Parameter m_parameter;
    private ComboViewer m_comboViewer;

    public ProcessInput(Parameter pa, DTraceRecorder recorder, Integer defaultPid) {
        super("value", "Process");
        this.m_parameter = pa;
        this.m_recorder = recorder;
        this.m_defaultPid = defaultPid;
    }

    public void create(Composite parent, int horizontalSpan) {
        GridData gd1 = new GridData(4, 4, false, false);
        gd1.verticalAlignment = 0x1000000;
        gd1.horizontalSpan = 1;
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        label.setLayoutData((Object)gd1);
        this.m_comboViewer = this.createComboViewer(parent, --horizontalSpan);
        this.schedulePeriodicProcessJob();
    }

    public void refresh() {
        this.getCCombo().setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.select(this.getPropertyValue());
        } else {
            this.getCCombo().setText("");
        }
    }

    private void select(String pid) {
        List<ProcessDescriptor> pds;
        if (this.hasValidCombo() && (pds = this.getProcessDescriptors()) != null) {
            for (ProcessDescriptor p : pds) {
                if (!pid.equals(String.valueOf(p.getIdentifier()))) continue;
                this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)p));
            }
        }
    }

    private List<ProcessDescriptor> getProcessDescriptors() {
        return (List)this.m_comboViewer.getInput();
    }

    public Control getControl() {
        if (this.m_comboViewer != null) {
            return this.m_comboViewer.getControl();
        }
        return null;
    }

    public CCombo getCCombo() {
        if (this.m_comboViewer != null) {
            return this.m_comboViewer.getCCombo();
        }
        return null;
    }

    private String getDefaultProcess(List<ProcessDescriptor> current) {
        for (ProcessDescriptor entry : current) {
            if (!ProcessInput.dtraceEnabled(entry)) continue;
            return String.valueOf(entry.getIdentifier());
        }
        return String.valueOf(current.get(0).getIdentifier());
    }

    static boolean dtraceEnabled(ProcessDescriptor pd) {
        return pd.getArguments().contains(DTRACE_MONITOR_PROBES_FLAG) || pd.getArguments().contains(EXTENDED_DTRACE_PROBES_FLAG);
    }

    public void dispose() {
        super.dispose();
    }

    private void schedulePeriodicProcessJob() {
        Job pj = new Job("Periodically retrieving PIDs from server"){

            protected IStatus run(IProgressMonitor monitor) {
                ProcessInput.this.updatePIDs(ProcessInput.this.m_parameter);
                return StatusFactory.createOk((String)"Completed");
            }
        };
        pj.setUser(false);
        pj.schedule();
    }

    private void updatePIDs(final Parameter parameter) {
        final List current = this.m_recorder.getProcesses(this.m_parameter.getValue(APPLICATION));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProcessInput.this.m_comboViewer.getControl().isDisposed()) {
                    ProcessInput.this.m_comboViewer.setInput((Object)current);
                    if (ProcessInput.this.m_defaultPid != null) {
                        String pid = String.valueOf(ProcessInput.this.m_defaultPid);
                        parameter.setLastValue(pid);
                        ProcessInput.this.select(pid);
                    } else if (current.indexOf(parameter.getLastValue()) == -1 && current.size() > 0) {
                        String defaultPID = ProcessInput.this.getDefaultProcess(current);
                        parameter.setLastValue(defaultPID);
                        ProcessInput.this.select(defaultPID);
                    }
                }
            }
        });
    }

    private ComboViewer createComboViewer(Composite parent, int horizontalSpan) {
        CCombo combo = new CCombo(parent, 2048);
        combo.setEditable(false);
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = horizontalSpan;
        combo.setLayoutData((Object)gd2);
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.getCCombo().setVisibleItemCount(10);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        new ToolTipManager((Composite)comboViewer.getCCombo(), (ToolTipManager.ToolTipProvider)new WrappedCmdlineTooltipProvider(this));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessInput.this.updatePropertyValue((ProcessDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement());
                ProcessInput.this.fireChange(IInput.STATUS_SETTING_CHANGE);
            }
        });
        return comboViewer;
    }

    private void updatePropertyValue(ProcessDescriptor p) {
        if (this.isEnabled() && p != null) {
            this.setPropertyValue(String.valueOf(p.getIdentifier()));
        }
    }

    private DecoratingLabelProvider createLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new ProcessLabelProvider(), (ILabelDecorator)new DTraceProcessDecorator());
    }

    ProcessDescriptor getSelectedProcess() {
        if (this.hasValidCombo()) {
            return (ProcessDescriptor)((IStructuredSelection)this.m_comboViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    private boolean hasValidCombo() {
        return this.m_comboViewer != null && this.m_comboViewer.getControl() != null && !this.m_comboViewer.getControl().isDisposed();
    }

    public void setEnabled(boolean enabled) {
        this.m_comboViewer.getControl().setEnabled(enabled);
    }
}

