/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.FieldInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.dtrace.events.code.Configuration;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.events.code.Probe;
import com.jrockit.mc.dtrace.events.code.ProbeSet;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import com.jrockit.mc.dtrace.events.code.Variable;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.dtrace.ui.wizard.process.ProcessInput;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FieldFactory;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

final class InputFactory {
    private static final String CONTENT_TYPE_BUFFER_POLICY = "bufferPolicy";
    private static final String CONTENT_TYPE_FLAG = "flag";
    private static final String CONTENT_TYPE_PROCESS = "process";
    private static final String VALUE = "value";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final int SPAN = 4;
    private final DTraceRecorder m_recorder;
    private final Configuration m_configuration;
    private final Integer m_defaultPid;
    private static final Logger LOGGER = DTraceUIPlugin.getDefault().getLogger();

    public InputFactory(Configuration configuration, DTraceRecorder recorder, Integer defaultPid) {
        this.m_configuration = configuration;
        this.m_recorder = recorder;
        this.m_defaultPid = defaultPid;
    }

    public Composite create(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        container.setLayout((Layout)layout);
        TemplateDescriptor templateDescriptor = this.m_configuration.getScript().getSelectedTemplate();
        if (templateDescriptor != null) {
            this.create(container, templateDescriptor.getRecordingTime());
            this.create(container, templateDescriptor.getBufferPolicy());
            for (Parameter parameter : templateDescriptor.getParameters()) {
                if (this.hasParam(parameter, templateDescriptor)) {
                    this.create(container, parameter);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Parameter " + parameter.getidentifier() + " not used in .de script");
            }
        }
        return container;
    }

    private IInput create(Composite c, Parameter pa) {
        String ct = pa.getType();
        if (CONTENT_TYPE_BUFFER_POLICY.equals(ct)) {
            return this.createBufferPolicy(c, pa);
        }
        if (CONTENT_TYPE_PROCESS.equals(ct)) {
            if (this.m_defaultPid == null) {
                return this.createProcessInput(c, pa);
            }
            pa.setLastValue(String.valueOf(this.m_defaultPid));
            return null;
        }
        if (CONTENT_TYPE_FLAG.equals(ct)) {
            return this.createBooleanInput(c, pa);
        }
        Field newField = FieldFactory.createFromDisplayUnit((UnitDescriptor)UnitLookup.getUnitDescriptor((String)ct), (String)"dummy", (int)0);
        return this.createUI(c, (IInput)new FieldInput(VALUE, pa.getName(), newField, (Object)this.getDefault(pa), (Object)this.getMin(pa), (Object)this.getMax(pa)), pa, this.getDefaultAsString(pa));
    }

    private String getDefaultAsString(Parameter pa) {
        return String.valueOf(this.getDefault(pa));
    }

    private Long getDefault(Parameter pa) {
        return this.getLong(pa.getLastValue(), new Long(0L));
    }

    private Long getMax(Parameter pa) {
        return this.getLong(pa.getValue(MAX), null);
    }

    private Long getMin(Parameter pa) {
        return this.getLong(pa.getValue(MIN), null);
    }

    private Long getLong(String p, Long defualt) {
        try {
            return Long.parseLong(p);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private IInput createBufferPolicy(Composite c, Parameter pa) {
        HashMap<String, String> policyMap = new HashMap<String, String>();
        policyMap.put("switch", "Switch Policy");
        policyMap.put("ring", "Ring Policy");
        policyMap.put("fill", "Fill Policy");
        ComboInput ci = new ComboInput(VALUE, "Buffer Policy", policyMap);
        return this.createUI(c, (IInput)ci, pa, pa.getLastValue());
    }

    private IInput createProcessInput(Composite c, Parameter pa) {
        ProcessInput pi = new ProcessInput(pa, this.m_recorder, this.m_defaultPid);
        return this.createUI(c, (IInput)pi, pa, null);
    }

    private IInput createBooleanInput(Composite c, Parameter pa) {
        boolean value = pa.getLastValue() == null ? Boolean.TRUE.toString().equalsIgnoreCase(pa.getLastValue()) : false;
        return this.createUI(c, (IInput)new BooleanInput(VALUE, pa.getName()), pa, Boolean.toString(value));
    }

    private IInput createUI(Composite c, IInput input, Parameter param, String value) {
        if (value != null) {
            param.setLastValue(value);
        }
        input.create(c, 4);
        input.setSetting(PersistenceToolkit.getSetting((Object)param));
        return input;
    }

    private boolean hasParam(Parameter param, TemplateDescriptor t) {
        for (ProbeSet ps : t.getProbeSets()) {
            if (!ps.isEnabled()) continue;
            for (Probe p : ps.getProbes()) {
                for (Variable v : p.getVariables()) {
                    String pa;
                    String va = v.getName();
                    if (!va.equals(pa = param.getidentifier())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

