/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.settings.FileInput;
import com.jrockit.mc.components.ui.settings.StatusWizardPage;
import com.jrockit.mc.dtrace.events.code.Configuration;
import com.jrockit.mc.dtrace.events.code.ProbeSet;
import com.jrockit.mc.dtrace.events.code.ScriptModel;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.dtrace.ui.WizardConfig;
import com.jrockit.mc.dtrace.ui.WorkspaceInstallation;
import com.jrockit.mc.dtrace.ui.wizard.CompilationErrorDialog;
import com.jrockit.mc.dtrace.ui.wizard.CompilationJob;
import com.jrockit.mc.dtrace.ui.wizard.InputFactory;
import com.jrockit.mc.dtrace.ui.wizard.ProbeSetContentProvider;
import com.jrockit.mc.dtrace.ui.wizard.ProbeSetProvider;
import com.jrockit.mc.dtrace.ui.wizard.SourceWizardPage;
import com.jrockit.mc.dtrace.ui.wizard.TemplateContentProvider;
import com.jrockit.mc.dtrace.ui.wizard.TemplateDescriptorLabelProvider;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.HelpSupport;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class DtraceRecordingWizardPage
extends StatusWizardPage
implements IPerformFinishable {
    private final InputFactory m_inputFactory;
    private final String m_title;
    private CheckboxTableViewer m_tableViewer;
    private Viewer m_comboViewer;
    private Composite m_detailsParent;
    private Composite m_details;
    private FileInput m_fileInput;
    private Control m_viewButton;
    private Control m_reloadButton;

    public DtraceRecordingWizardPage(Configuration configuration, WizardConfig wc) {
        super((Object)configuration);
        this.m_title = wc.getWizardTitle();
        this.m_inputFactory = new InputFactory(this.getConfiguration(), wc.getRecorder(), wc.getPid());
    }

    protected Control createControlArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.getShell().setImage(DTraceUIPlugin.getDefault().getImage("editor.gif"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Control fileContainer = this.createFileContainer(container);
        fileContainer.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        Control mainContainer = this.createMainContainer(container);
        mainContainer.setLayoutData((Object)gd2);
        this.updateButtonEnablement();
        if (this.getConfiguration().getScript() == null) {
            this.compileFile();
        }
        return container;
    }

    private Control createMainContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, true);
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.horizontalSpan = 5;
        this.m_comboViewer = this.createCombo(container);
        this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.m_tableViewer = this.createTable(container);
        this.m_tableViewer.getControl().setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, true);
        gd4.horizontalSpan = 3;
        this.m_detailsParent = this.createOptions(container);
        this.m_detailsParent.setLayoutData((Object)gd4);
        this.m_detailsParent.setLayout((Layout)new FillLayout());
        TemplateDescriptor temaplateDescriptor = this.getConfiguration().getSelectedTemplate();
        this.m_tableViewer.setInput((Object)this.getConfiguration());
        if (temaplateDescriptor != null) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)temaplateDescriptor));
        }
        this.setMessage("Select a recording profile and click OK to start the recording.");
        return container;
    }

    private Control createFileContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(5, false));
        GridData gd1 = new GridData(4, 4, true, false);
        Control fileSelection = this.createFileSelection(container);
        fileSelection.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_reloadButton = this.createReloadButton(container);
        this.m_reloadButton.setLayoutData((Object)gd2);
        this.m_reloadButton.setEnabled(false);
        GridData gd3 = new GridData(4, 4, false, false);
        this.m_viewButton = this.createView(container);
        this.m_viewButton.setLayoutData((Object)gd3);
        this.m_viewButton.setEnabled(false);
        GridData gd5 = new GridData(4, 4, false, false);
        Button refreshButton = this.createDefaultButton(container);
        refreshButton.setLayoutData((Object)gd5);
        GridData gd4 = new GridData(4, 4, false, false);
        Button helpButton = this.createHelpButton(container);
        helpButton.setLayoutData((Object)gd4);
        return container;
    }

    private Button createHelpButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText("Help");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DtraceRecordingWizardPage.this.showHelp();
            }
        });
        return button;
    }

    private void showHelp() {
        Action a = HelpSupport.getHelpAction((String)"com.jrockit.mc.dtrace.ui.using");
        if (a != null) {
            a.run();
        }
    }

    private Control createView(Composite container) {
        Button button = new Button(container, 0);
        button.setText("View");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DtraceRecordingWizardPage.this.showFile();
            }
        });
        return button;
    }

    private void showFile() {
        File file = this.getFile();
        ScriptModel script = this.getConfiguration().getScript();
        if (file == null || script == null) {
            SourceWizardPage s = new SourceWizardPage(script.getSourceCode(), file.getAbsolutePath());
            OnePageWizardDialog o = new OnePageWizardDialog(this.getShell(), (IWizardPage)s);
            o.setTitle(this.getFile().toString());
            o.open();
        } else {
            this.setErrorMessage("No script file");
        }
    }

    private Control createFileSelection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.m_fileInput = new FileInput("sourceFile", "DTrace Event Script");
        this.m_fileInput.setMustExist(true);
        this.m_fileInput.setAllowDirectory(false);
        this.m_fileInput.create(container, layout.numColumns);
        this.m_fileInput.setSetting(PersistenceToolkit.getSetting((Object)this.getConfiguration()));
        this.m_fileInput.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                if (status.getSeverity() == 0) {
                    DtraceRecordingWizardPage.this.compileFile();
                }
            }
        });
        return container;
    }

    private Button createReloadButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText("Update");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DtraceRecordingWizardPage.this.compileFile();
            }
        });
        return button;
    }

    private Button createDefaultButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText("Default");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DtraceRecordingWizardPage.this.selectDefaultFile();
            }
        });
        return button;
    }

    private void selectDefaultFile() {
        try {
            File defaultScript = WorkspaceInstallation.INSTANCE.install(this.getShell(), (IProgressMonitor)new NullProgressMonitor());
            this.getConfiguration().setScript(null);
            this.getConfiguration().setSourceFile(defaultScript);
            this.getFileInput().setFile(defaultScript.getAbsoluteFile());
            this.compileFile();
        }
        catch (IOException e) {
            this.setPageComplete(false);
            this.setErrorMessage(e.getMessage());
        }
    }

    private FileInput getFileInput() {
        return this.m_fileInput;
    }

    private Composite createOptions(Composite parent) {
        return new Composite(parent, 0);
    }

    private CheckboxTableViewer createTable(Composite parent) {
        CheckboxTableViewer checkboxViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        checkboxViewer.setContentProvider((IContentProvider)new ProbeSetContentProvider());
        checkboxViewer.setLabelProvider((IBaseLabelProvider)new ProbeSetProvider());
        checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProbeSet td;
                if (event.getElement() instanceof ProbeSet && (td = (ProbeSet)event.getElement()).isEnabled() != event.getChecked()) {
                    td.setEnabled(event.getChecked());
                    DtraceRecordingWizardPage.this.updateSettings();
                }
            }
        });
        return checkboxViewer;
    }

    private void updateSettings() {
        if (this.m_details != null) {
            this.m_details.dispose();
        }
        if (this.getConfiguration().getScript() != null) {
            this.m_details = this.m_inputFactory.create(this.m_detailsParent);
        }
        this.m_detailsParent.layout(true, true);
    }

    private Configuration getConfiguration() {
        return (Configuration)this.getConfigurationObject();
    }

    private void updateButtonEnablement() {
        this.m_viewButton.setEnabled(this.hasFile());
        this.m_reloadButton.setEnabled(this.hasFile());
    }

    private boolean hasFile() {
        File file = this.getFile();
        if (file != null) {
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    protected void exportScript(ScriptModel script) {
        block6: {
            FileDialog dialog = new FileDialog(this.getShell(), 0);
            String fileName = dialog.open();
            if (fileName != null) {
                FileWriter fw = null;
                BufferedWriter wr = null;
                try {
                    try {
                        fw = new FileWriter(new File(fileName));
                        wr = new BufferedWriter(fw);
                        fw.write(script.getSourceCode());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        IOToolkit.closeSilently(fw);
                        IOToolkit.closeSilently(wr);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(fw);
                    IOToolkit.closeSilently(wr);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)fw);
                IOToolkit.closeSilently((Closeable)wr);
            }
        }
    }

    private void selectFirstTemplate(TemplateDescriptor t) {
        this.m_comboViewer.refresh();
        if (t == null) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection());
            this.m_tableViewer.refresh();
        } else {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)t));
        }
    }

    private void compileFile() {
        block7: {
            File file = this.getFile();
            if (file != null) {
                if (file.isFile()) {
                    this.setErrorMessage(null);
                    try {
                        String sourceCode = this.readSource(file);
                        if (sourceCode.trim().length() != 0) {
                            this.scheduleCompilation(sourceCode);
                            break block7;
                        }
                        this.getConfiguration().setScript(new ScriptModel());
                        this.setErrorMessage("No source code in file");
                        this.setPageComplete(false);
                    }
                    catch (IOException e) {
                        this.setErrorMessage(e.getMessage());
                        this.setPageComplete(false);
                    }
                } else {
                    this.setErrorMessage("Could not find DTrace Event Script File on disk. Please browse to adjust the path or click Default to use the default file");
                    this.setPageComplete(false);
                }
            } else {
                this.setErrorMessage("Missing DTrace Event Script File. Please browse to adjust the path or click Default to use the default file");
                this.setPageComplete(false);
            }
        }
    }

    private void scheduleCompilation(String sourceCode) {
        final CompilationJob cj = new CompilationJob(sourceCode);
        cj.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ScriptModel p = cj.getScriptModel();
                        if (p != null) {
                            DtraceRecordingWizardPage.this.getConfiguration().setScript(p);
                            List tds = p.getTemplates();
                            if (tds.size() > 0) {
                                DtraceRecordingWizardPage.this.selectFirstTemplate((TemplateDescriptor)tds.get(0));
                            } else {
                                DtraceRecordingWizardPage.this.selectFirstTemplate(null);
                            }
                            DtraceRecordingWizardPage.this.setPageComplete(true);
                            DtraceRecordingWizardPage.this.updateButtonEnablement();
                        } else {
                            CompilationErrorDialog.show(DtraceRecordingWizardPage.this.getShell(), cj.getProgress());
                            DtraceRecordingWizardPage.this.setPageComplete(false);
                            DtraceRecordingWizardPage.this.updateButtonEnablement();
                        }
                    }
                });
            }
        });
        cj.schedule();
    }

    private String readSource(File file) throws IOException {
        String string;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String sourceCode;
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            while (br.ready()) {
                sb.append(br.readLine());
                sb.append("\r\n");
            }
            string = sourceCode = sb.toString();
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(br);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)br);
        return string;
    }

    private File getFile() {
        return this.getConfiguration().getSourceFile();
    }

    private Viewer createCombo(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new TemplateDescriptorLabelProvider());
        comboViewer.setInput((Object)this.getConfiguration());
        comboViewer.refresh();
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    DtraceRecordingWizardPage.this.selectTemplate((TemplateDescriptor)ss.getFirstElement());
                }
            }
        });
        return comboViewer;
    }

    void refresh() {
        this.m_tableViewer.refresh();
        IStructuredSelection ss = (IStructuredSelection)this.m_comboViewer.getSelection();
        if (!ss.isEmpty()) {
            TemplateDescriptor t = (TemplateDescriptor)ss.getFirstElement();
            ArrayList<ProbeSet> selectedProbeSets = new ArrayList<ProbeSet>();
            for (ProbeSet p : t.getProbeSets()) {
                if (!p.isEnabled()) continue;
                selectedProbeSets.add(p);
            }
            this.m_tableViewer.setCheckedElements(selectedProbeSets.toArray());
        } else {
            this.m_tableViewer.setCheckedElements(new Object[0]);
            Configuration conf = this.getConfiguration();
            List ts = conf.getScript().getTemplates();
            if (!ts.isEmpty()) {
                this.m_comboViewer.setSelection((ISelection)new StructuredSelection(ts.get(0)), true);
                this.m_comboViewer.refresh();
            }
        }
        this.updateSettings();
    }

    private void selectTemplate(TemplateDescriptor templateDescriptor) {
        ScriptModel sc = this.getConfiguration().getScript();
        for (TemplateDescriptor te : sc.getTemplates()) {
            te.setSelected(false);
        }
        if (templateDescriptor != null) {
            templateDescriptor.setSelected(true);
        }
        this.refresh();
    }

    protected String createTitle() {
        return this.m_title;
    }

    public ScriptModel getScript() {
        return this.getConfiguration().getScript();
    }
}

