/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard;

import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.ScriptFactory;
import com.jrockit.mc.dtrace.events.code.ScriptModel;
import com.jrockit.mc.dtrace.events.code.SimpleProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public final class CompilationJob
extends Job {
    private final String m_sourceCode;
    private final SimpleProgress m_progress = new SimpleProgress();
    private volatile ScriptModel m_scriptModel;

    public CompilationJob(String sourceCode) {
        super("Compiling script");
        this.setUser(false);
        this.m_sourceCode = sourceCode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ScriptFactory sc = new ScriptFactory(this.m_sourceCode);
            this.m_scriptModel = sc.createScriptModel((IProgress)this.m_progress);
            if (!this.m_progress.hasErrors()) {
                return StatusFactory.createOk((String)"Script compiled successfully");
            }
            return StatusFactory.createErr((String)"Could not compile script");
        }
        catch (RuntimeException e) {
            return StatusFactory.createErr((String)"Unexpected error when trying to compile script", (Throwable)e, (boolean)true);
        }
    }

    public ScriptModel getScriptModel() {
        return this.m_scriptModel;
    }

    public SimpleProgress getProgress() {
        return this.m_progress;
    }
}

