/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.wizard;

import com.jrockit.mc.dtrace.events.code.SimpleProgress;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class CompilationErrorDialog
extends WizardPage {
    private static final Field ERROR_FIELD = new StringField(0);
    private static final Field[] FIELDS = new Field[]{ERROR_FIELD};
    private final SimpleProgress m_progress;

    static {
        ERROR_FIELD.setName("Error");
    }

    private CompilationErrorDialog(SimpleProgress progress) {
        super("importErrorPage");
        this.m_progress = progress;
        this.setImageDescriptor(DTraceUIPlugin.getDefault().getMCImageDescriptor("error_wiz.gif"));
    }

    public static void show(Shell shell, SimpleProgress sp) {
        CompilationErrorDialog iep = new CompilationErrorDialog(sp);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)iep);
        dialog.setMinimumPageSize(600, 300);
        dialog.open();
    }

    public void createControl(Composite parent) {
        FieldTableViewer tv = CompilationErrorDialog.createWithStandardTable(parent, FIELDS);
        tv.setContentProvider((IContentProvider)new ErrorProvider());
        tv.setInput((Object)this.m_progress);
        tv.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(FIELDS, (IBaseLabelProvider)new IconProvder()));
        this.setDescription("Could not compile DTrace event script");
        this.setTitle("Compilation Error");
        this.setControl(tv.getControl());
    }

    public static FieldTableViewer createWithStandardTable(Composite parent, Field[] fields) {
        Table table = new Table(parent, 268503810);
        return new FieldTableViewer(table, fields);
    }

    private static final class ErrorProvider
    extends AbstractFieldTableContentProvider {
        private ErrorProvider() {
        }

        public Object[] getRowElements(Object inputElement) {
            SimpleProgress sp = (SimpleProgress)inputElement;
            List errors = sp.getErrors();
            return errors.toArray();
        }

        public Object[] getColumnObject(Object inputElement) {
            Object[] result = new Object[FIELDS.length];
            result[0] = inputElement;
            return result;
        }
    }

    public class IconProvder
    extends LabelProvider {
        public Image getImage(Object element) {
            return UIPlugin.getDefault().getImage("error_obj.gif");
        }
    }
}

