/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.input;

public final class CharacterChunk {
    public static final int STOP_READ_BEFORE_END = 500;
    public int index = 500;
    public final char[] characters;
    private int overlapBegin;
    private final int end;

    public CharacterChunk(char[] characters, int start, int overlap, int end) {
        this.characters = characters;
        this.index = start;
        this.end = end;
        this.overlapBegin = overlap;
    }

    public boolean isInOverlap() {
        return this.index >= this.overlapBegin;
    }

    public int nextTokenStart() {
        while (this.index < this.end) {
            char c = this.characters[this.index];
            if (!CharacterChunk.isBreakCharacter(c)) {
                return this.index;
            }
            ++this.index;
        }
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static boolean isBreakCharacter(char c) {
        return c == ' ' || c == '\n' || c == '\u0000' || c == '\r';
    }

    public int nextTokenEnd() {
        while (this.index < this.end) {
            if (CharacterChunk.isBreakCharacter(this.characters[this.index])) {
                return this.index;
            }
            ++this.index;
        }
        return this.index;
    }

    public int getOverlap() {
        return this.index - this.overlapBegin;
    }

    public void copyLeftOvers(CharacterChunk next) {
        int overlap;
        next.index = overlap = this.getOverlap();
        while (this.index < this.end) {
            char ct = this.characters[this.index++];
            next.characters[next.index++] = ct;
        }
        next.index = overlap;
    }

    public String readLine() {
        int i = this.index;
        int start = this.index;
        while (i < this.end && this.characters[i] != '\n') {
            ++i;
        }
        if (start == i) {
            return "";
        }
        return new String(this.characters, start, i - start);
    }

    public void next(char c) {
        while (this.index < this.end) {
            if (this.characters[this.index] == c) {
                return;
            }
            ++this.index;
        }
    }

    public void removeOverlap() {
        this.overlapBegin = this.end - 1;
    }

    public int nextLine() {
        while (this.index < this.end) {
            if (this.characters[this.index] == '\n') {
                return this.index;
            }
            ++this.index;
        }
        return -1;
    }
}

