/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.chunk;

import com.jrockit.mc.dtrace.ui.parser.text.chunk.AbstractLineProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.Line;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Sorter
extends AbstractLineProcessor {
    private final List<Line> m_lines = new ArrayList<Line>();
    private long m_lastTime;

    public Sorter(File file) throws IOException {
        super(file);
    }

    @Override
    public void processChunkPart(CharacterChunk chunk) {
        int start = chunk.index;
        int timeStart = chunk.nextTokenStart();
        int end = chunk.nextLine();
        if (end != -1) {
            int length = end - start + 1;
            long time = this.parseTimeStamp(chunk.characters, timeStart, end);
            if (time == -1L) {
                return;
            }
            if (time < this.m_lastTime) {
                this.m_lines.add(new Line(time, chunk.characters, start, length));
            } else {
                this.writeLine(chunk.characters, start, length);
                this.m_lastTime = time;
            }
        }
    }

    public final List<Line> getLines() {
        return this.m_lines;
    }
}

