/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.chunk;

import com.jrockit.mc.dtrace.ui.input.IChunkInput;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.IProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import java.io.IOException;

public final class Runner {
    private final IProcessor m_process;

    public Runner(IProcessor processor) {
        this.m_process = processor;
    }

    public void run(IChunkInput<CharacterChunk> input) throws IOException {
        this.m_process.initialize();
        CharacterChunk current = input.nextChunk();
        while (current != null) {
            this.readChunk(current);
            CharacterChunk next = input.nextChunk();
            if (next != null) {
                current.copyLeftOvers(next);
            } else {
                current.removeOverlap();
                this.readChunk(current);
            }
            current = next;
        }
        this.m_process.finish();
    }

    protected void readChunk(CharacterChunk chunk) {
        while (!chunk.isInOverlap()) {
            this.m_process.processChunkPart(chunk);
        }
    }
}

