/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.chunk;

import com.jrockit.mc.dtrace.ui.parser.text.chunk.AbstractLineProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.Line;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class Merger
extends AbstractLineProcessor {
    private final Iterator<Line> m_LineIterator;
    private Line m_current;

    public Merger(File file, List<Line> lines) throws IOException {
        super(file);
        this.m_LineIterator = lines.iterator();
        this.nextLine();
    }

    @Override
    public void processChunkPart(CharacterChunk chunk) {
        int start = chunk.index;
        int timeStart = chunk.nextTokenStart();
        int end = chunk.nextLine();
        if (end != -1) {
            int length = end - start + 1;
            long time = this.parseTimeStamp(chunk.characters, timeStart, end);
            if (time == -1L) {
                return;
            }
            this.writeSorted(time);
            this.writeLine(chunk.characters, start, length);
        }
    }

    private void writeSorted(long time) {
        while (this.m_current != null && time >= this.m_current.getTimestamp()) {
            this.writeLine(this.m_current);
            this.nextLine();
        }
    }

    private void nextLine() {
        this.m_current = this.m_LineIterator.hasNext() ? this.m_LineIterator.next() : null;
    }

    @Override
    public void initialize() {
        this.nextLine();
    }

    @Override
    public void finish() {
        this.writeSorted(Long.MAX_VALUE);
    }
}

