/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.chunk;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

final class Line
implements Comparable<Line> {
    private final char[] m_characters;
    private final int m_start;
    private final int m_length;
    private final long m_timestamp;

    public Line(long timestamp, char[] chars, int start, int length) {
        this.m_characters = chars;
        this.m_start = start;
        this.m_length = length;
        this.m_timestamp = timestamp;
    }

    @Override
    public int compareTo(Line that) {
        if (that.getTimestamp() > this.m_timestamp) {
            return -1;
        }
        if (that.getTimestamp() < this.m_timestamp) {
            return 1;
        }
        return 0;
    }

    long getTimestamp() {
        return this.m_timestamp;
    }

    public char[] getCharacters() {
        return this.m_characters;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getLength() {
        return this.m_length;
    }

    void write(Writer writer) throws IOException {
        writer.write(this.m_characters, this.m_start, this.m_length);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = this.m_start;
        while (i < this.m_start + this.m_length) {
            sb.append('\'');
            sb.append(this.m_characters[i]);
            sb.append('\'');
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_characters);
        result = 31 * result + this.m_length;
        result = 31 * result + this.m_start;
        result = 31 * result + (int)(this.m_timestamp ^ this.m_timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (!Arrays.equals(this.m_characters, other.m_characters)) {
            return false;
        }
        if (this.m_length != other.m_length) {
            return false;
        }
        if (this.m_start != other.m_start) {
            return false;
        }
        return this.m_timestamp == other.m_timestamp;
    }
}

