/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text.chunk;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.IProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.Line;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public abstract class AbstractLineProcessor
implements IProcessor {
    private final BufferedWriter m_bufferedWriter;

    protected AbstractLineProcessor(File file) throws IOException {
        this.m_bufferedWriter = new BufferedWriter(new FileWriter(file));
    }

    protected final void writeLine(Line line) {
        this.writeLine(line.getCharacters(), line.getStart(), line.getLength());
    }

    protected final void writeLine(char[] characters, int start, int length) {
        try {
            this.m_bufferedWriter.write(characters, start, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void finish() {
        IOToolkit.closeSilently((Closeable)this.m_bufferedWriter);
    }

    protected final long parseTimeStamp(char[] characters, int start, int end) {
        long value = 0L;
        int n = start;
        while (n < end) {
            char c = characters[n];
            if (c >= '0' && c <= '9') {
                value *= 10L;
                value += (long)(characters[n] - 48);
            } else {
                return value;
            }
            ++n;
        }
        return -1L;
    }
}

