/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text;

import com.jrockit.mc.dtrace.ui.parser.text.IParser;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;

public final class StringParser
implements IParser {
    private final char[] buffer = new char[512];
    private int m_lastLength = -1;
    private String cacheString;

    @Override
    public String read(CharacterChunk chunk) {
        int start = chunk.nextTokenStart();
        ++chunk.index;
        chunk.next('\"');
        ++chunk.index;
        int length = chunk.index - start - 2;
        if (length == this.m_lastLength && length < 512 && this.inCache(chunk.characters, start)) {
            return this.cacheString;
        }
        this.cacheString = new String(chunk.characters, start + 1, length);
        this.m_lastLength = length;
        return this.cacheString;
    }

    private boolean inCache(char[] characters, int index) {
        int n = 0;
        while (n < this.m_lastLength) {
            if (this.buffer[n] != characters[n + index]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

