/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text;

import com.jrockit.mc.dtrace.ui.parser.text.BooleanParser;
import com.jrockit.mc.dtrace.ui.parser.text.CompositeParser;
import com.jrockit.mc.dtrace.ui.parser.text.Datatype;
import com.jrockit.mc.dtrace.ui.parser.text.DoubleParser;
import com.jrockit.mc.dtrace.ui.parser.text.FloatParser;
import com.jrockit.mc.dtrace.ui.parser.text.IParser;
import com.jrockit.mc.dtrace.ui.parser.text.IntegerParser;
import com.jrockit.mc.dtrace.ui.parser.text.LongParser;
import com.jrockit.mc.dtrace.ui.parser.text.StringParser;
import com.jrockit.mc.dtrace.ui.parser.text.SymbolParser;
import java.util.List;

public final class ParserFactory {
    public static IParser createValueParser(Datatype dt) {
        if (dt.isComposite()) {
            return ParserFactory.createCompositeParser(dt.getChildren());
        }
        if (dt.equals(Datatype.STRING)) {
            return new StringParser();
        }
        if (dt.isInteger() || dt.isShort()) {
            return new IntegerParser();
        }
        if (dt.isLong()) {
            return new LongParser();
        }
        if (dt.equals(Datatype.FLOAT)) {
            return new FloatParser();
        }
        if (dt.equals(Datatype.DOUBLE)) {
            return new DoubleParser();
        }
        if (dt.equals(Datatype.SYMBOL)) {
            return new SymbolParser();
        }
        if (dt.equals(Datatype.BOOLEAN)) {
            return new BooleanParser();
        }
        throw new IllegalStateException("Unknown data type " + dt);
    }

    public static IParser createCompositeParser(List<Datatype> dataTypes) {
        IParser[] parsers = new IParser[dataTypes.size()];
        int n = 0;
        while (n < parsers.length) {
            parsers[n] = ParserFactory.createValueParser(dataTypes.get(n));
            ++n;
        }
        return new CompositeParser(parsers);
    }
}

