/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.parser.text;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import java.util.Arrays;
import java.util.List;

public final class Datatype {
    private static final String DATA_TYPES = "dataTypes";
    private static final String NAME = "name";
    public static final Datatype INTEGER = new Datatype("int", new Datatype[0]);
    public static final Datatype BOOLEAN = new Datatype("boolean", new Datatype[0]);
    public static final Datatype STRING = new Datatype("string", new Datatype[0]);
    public static final Datatype FLOAT = new Datatype("float", new Datatype[0]);
    public static final Datatype SYMBOL = new Datatype("symbol", new Datatype[0]);
    public static final Datatype LONG = new Datatype("long", new Datatype[0]);
    public static final Datatype SHORT = new Datatype("short", new Datatype[0]);
    public static final Datatype DOUBLE = new Datatype("double", new Datatype[0]);
    private final Setting m_setting = new Setting("dataType");

    static {
        PersistenceToolkit.registerFetcher(Datatype.class, (ISettingFetcher)new ISettingFetcher<Datatype>(){

            public Setting getSetting(Datatype valueDescriptor) {
                return valueDescriptor.m_setting;
            }
        });
    }

    public Datatype() {
        this.setKey("composite");
    }

    public Datatype(String key, Datatype ... children) {
        this.getChildren().addAll(Arrays.asList(children));
        this.setKey(key);
    }

    public static Datatype createComposite(Datatype ... children) {
        return new Datatype("composite", children);
    }

    public boolean isString() {
        return this.equals(STRING) || this.equals(SYMBOL);
    }

    public boolean isInteger() {
        return this.equals(INTEGER);
    }

    public boolean isComposite() {
        return !this.getChildren().isEmpty();
    }

    private void setKey(String key) {
        this.m_setting.setChildObject(NAME, (Object)key);
    }

    public List<Datatype> getChildren() {
        return (List)this.m_setting.getChildObject(DATA_TYPES, new Type(List.class, new Type[]{new Type(Datatype.class)}));
    }

    public String getKey() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public boolean isNumeric() {
        return this.equals(SHORT) || this.equals(INTEGER) || this.equals(LONG) || this.equals(FLOAT) || this.equals(SYMBOL);
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Datatype) {
            return ((Datatype)o).getKey().equals(this.getKey());
        }
        return false;
    }

    public String toString() {
        return this.getKey();
    }

    public boolean isBoolean() {
        return this.equals(BOOLEAN);
    }

    public boolean isShort() {
        return this.equals(SHORT);
    }

    public boolean isLong() {
        return this.equals(LONG);
    }
}

