/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.input;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

final class TerminatableQueue<T> {
    private final Object m_lock = new Object();
    private final Queue<T> m_queue = new LinkedList<T>();
    private final int m_capacity;
    private boolean m_terminated = false;
    private IOException m_exception = null;

    TerminatableQueue(int capacity) {
        this.m_capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTerminated() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_terminated = true;
            this.m_queue.clear();
            this.m_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void add(T t) {
        Object object = this.m_lock;
        synchronized (object) {
            while (true) {
                if (!this.isFull() || this.isTerminated()) {
                    if (this.isTerminated()) return;
                    this.m_queue.add(t);
                    this.m_lock.notifyAll();
                    return;
                }
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException e) {
                    this.terminate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    T poll() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            while (true) {
                if (!this.m_queue.isEmpty() || this.isTerminated()) {
                    T t = this.m_queue.poll();
                    if (t == null) break;
                    this.m_lock.notifyAll();
                    return t;
                }
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException e) {
                    this.terminate();
                }
            }
            if (this.getException() != null) {
                IOException e = this.getException();
                this.setException(null);
                throw e;
            }
            this.terminate();
            return null;
        }
    }

    private IOException getException() {
        return this.m_exception;
    }

    public void setException(IOException exception) {
        this.m_exception = exception;
    }

    private boolean isFull() {
        return this.m_queue.size() >= this.m_capacity;
    }
}

