/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.input;

import com.jrockit.mc.dtrace.ui.input.IChunkInput;
import com.jrockit.mc.dtrace.ui.input.TerminatableQueue;
import java.io.IOException;

public final class BackgroundInput<T>
implements IChunkInput<T> {
    private final TerminatableQueue<T> m_queue;
    private final IChunkInput<T> m_input;

    public BackgroundInput(IChunkInput<T> input, int capacity) {
        this.m_queue = new TerminatableQueue(capacity);
        this.m_input = input;
        this.start();
    }

    void start() {
        new Thread(this.createReader()).start();
    }

    private Runnable createReader() {
        return new Runnable(){

            @Override
            public void run() {
                BackgroundInput.this.read();
            }
        };
    }

    private void read() {
        while (!this.m_queue.isTerminated()) {
            try {
                this.m_queue.add(this.m_input.nextChunk());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.m_queue.setException(e);
                this.m_queue.terminate();
            }
        }
    }

    void stop() {
        this.m_queue.terminate();
    }

    @Override
    public T nextChunk() throws IOException {
        return this.m_queue.poll();
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
        this.stop();
    }
}

